/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.heat;

import net.minecraft.ChatFormatting;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public enum Heat {
    WARMING(0.0f, 80.0f, ChatFormatting.GRAY),
    HOT(80.0f, 210.0f, ChatFormatting.GRAY),
    VERY_HOT(210.0f, 480.0f, ChatFormatting.GRAY),
    FAINT_RED(480.0f, 580.0f, ChatFormatting.DARK_RED),
    DARK_RED(580.0f, 730.0f, ChatFormatting.DARK_RED),
    BRIGHT_RED(730.0f, 930.0f, ChatFormatting.RED),
    ORANGE(930.0f, 1100.0f, ChatFormatting.GOLD),
    YELLOW(1100.0f, 1300.0f, ChatFormatting.YELLOW),
    YELLOW_WHITE(1300.0f, 1400.0f, ChatFormatting.YELLOW),
    WHITE(1400.0f, 1500.0f, ChatFormatting.WHITE),
    BRILLIANT_WHITE(1500.0f, 1600.0f, ChatFormatting.WHITE);

    private static final Heat[] VALUES;
    private final ChatFormatting color;
    private final float min;
    private final float max;

    public static int scaleTemperatureForGui(float temperature) {
        return Mth.clamp((int)((int)(51.0f * temperature / BRILLIANT_WHITE.getMax())), (int)0, (int)51);
    }

    public static float maxVisibleTemperature() {
        return BRILLIANT_WHITE.getMax();
    }

    @Nullable
    public static Heat getHeat(float temperature) {
        if (temperature > Heat.WARMING.min) {
            for (Heat heat : VALUES) {
                if (!(temperature < heat.max)) continue;
                return heat;
            }
            return BRILLIANT_WHITE;
        }
        return null;
    }

    private Heat(float min, float max, ChatFormatting color) {
        this.min = min;
        this.max = max;
        this.color = color;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    static {
        VALUES = Heat.values();
    }
}

