/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.heat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.HeatDefinition;
import net.dries007.tfc.common.component.heat.IHeatView;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class HeatComponent
implements IHeatView {
    public static final Codec<HeatComponent> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.optionalFieldOf("capacity", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.heatCapacity)), (App)Codec.FLOAT.optionalFieldOf("temperature", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.lastTemperature)), (App)Codec.LONG.optionalFieldOf("tick", (Object)0L).forGetter(c -> c.lastTick)).apply((Applicative)i, HeatComponent::new)).xmap(Function.identity(), HeatComponent::sanitize);
    public static final StreamCodec<ByteBuf, HeatComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.heatCapacity), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.lastTemperature), (StreamCodec)ByteBufCodecs.VAR_LONG, c -> c.lastTick, HeatComponent::new);
    public static final HeatComponent EMPTY = new HeatComponent(null, 0.0f, 0.0f, 0L);
    @Nullable
    private HeatDefinition parent;
    private final float heatCapacity;
    private float lastTemperature;
    private long lastTick;

    public static HeatComponent of(float heatCapacity) {
        return new HeatComponent(null, heatCapacity, 0.0f, 0L);
    }

    public static HeatComponent of(float heatCapacity, float temperatureNow) {
        return new HeatComponent(null, heatCapacity, temperatureNow, Calendars.get().getTicks());
    }

    public static HeatComponent of(HeatDefinition parent) {
        return new HeatComponent(parent, 0.0f, 0.0f, 0L);
    }

    HeatComponent(float heatCapacity, float lastTemperature, long lastTick) {
        this(null, heatCapacity, lastTemperature, lastTick);
    }

    HeatComponent(@Nullable HeatDefinition parent, float heatCapacity, float lastTemperature, long lastTick) {
        this.parent = parent;
        this.heatCapacity = heatCapacity;
        this.lastTemperature = lastTemperature;
        this.lastTick = lastTick == -1L ? Calendars.get().getTicks() : lastTick;
    }

    public void capture(ItemStack stack) {
        if (this.parent == null) {
            this.parent = HeatCapability.getDefinition(stack);
            if (this.parent == null) {
                this.parent = HeatDefinition.DEFAULT;
            }
        }
    }

    @Override
    public float getTemperature() {
        return this.sanitize().calculateTemperature();
    }

    private float calculateTemperature() {
        return HeatCapability.adjustTemp(this.lastTemperature, this.getHeatCapacity(), Calendars.get().getTicks() - this.lastTick);
    }

    @Override
    public float getHeatCapacity() {
        if (this.heatCapacity == -1.0f) {
            return Float.POSITIVE_INFINITY;
        }
        if (this.heatCapacity != 0.0f) {
            return this.heatCapacity;
        }
        if (this.parent != null) {
            return this.parent.heatCapacity();
        }
        return Float.POSITIVE_INFINITY;
    }

    @Override
    public float getWorkingTemperature() {
        return this.parent == null ? 0.0f : this.parent.forgingTemperature();
    }

    @Override
    public float getWeldingTemperature() {
        return this.parent == null ? 0.0f : this.parent.weldingTemperature();
    }

    @Override
    public void addTooltipInfo(ItemStack stack, Consumer<Component> text) {
        if (this.heatCapacity != -1.0f) {
            IHeatView.super.addTooltipInfo(stack, text);
        }
    }

    HeatComponent sanitize() {
        if (!(this.parent == null && this.heatCapacity == 0.0f || this.lastTemperature == 0.0f && this.lastTick == 0L)) {
            this.lastTemperature = Math.max(0.0f, this.calculateTemperature());
            this.lastTick = this.lastTemperature <= 0.0f ? 0L : Calendars.get().getTicks();
        }
        return this;
    }

    HeatComponent with(float temperature, long tick) {
        return new HeatComponent(this.parent, this.heatCapacity, temperature, tick);
    }

    HeatComponent withHeatCapacity(float heatCapacity) {
        return new HeatComponent(this.parent, heatCapacity, this.getTemperature(), Calendars.get().getTicks());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HeatComponent) {
            HeatComponent that = (HeatComponent)obj;
            this.sanitize();
            that.sanitize();
            return this.heatCapacity == that.heatCapacity && this.lastTick == that.lastTick && this.lastTemperature == that.lastTemperature;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.heatCapacity));
    }

    public String toString() {
        return "Heat[parent=%s%s,lastTick=%s,lastTemperature=%5.0f,temperature=%5.0f]".formatted(this.parent != null ? Objects.requireNonNullElse(HeatCapability.MANAGER.getId(this.parent), "<custom>") : "<null>", this.heatCapacity == 0.0f ? "" : ",heatCapacity=" + this.heatCapacity, this.lastTick == Calendars.get().getTicks() ? "<now>" : "%8d".formatted(this.lastTick), Float.valueOf(this.lastTemperature), Float.valueOf(this.getTemperature()));
    }
}

