/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.heat;

import net.dries007.tfc.common.component.heat.IHeatView;
import org.jetbrains.annotations.Nullable;

public interface IHeat
extends IHeatView {
    public void setTemperature(float var1);

    default public void setTemperatureIfWarmer(float temperature) {
        float current = this.getTemperature();
        if (temperature > current) {
            this.setTemperature(temperature);
        }
    }

    default public void setTemperatureIfWarmer(@Nullable IHeat other) {
        if (other != null) {
            this.setTemperatureIfWarmer(other.getTemperature());
        }
    }

    default public void addTemperatureFromSourceWithHeatCapacity(float temperature, float heatCapacity) {
        float currentTemperature = this.getTemperature();
        float currentHeatCapacity = this.getHeatCapacity();
        float totalHeatCapacity = currentHeatCapacity + heatCapacity;
        this.setTemperature(currentTemperature * currentHeatCapacity / totalHeatCapacity + temperature * heatCapacity / totalHeatCapacity);
    }

    public void setHeatCapacity(float var1);

    default public void setStaticTemperature(float value) {
        this.setHeatCapacity(-1.0f);
        this.setTemperature(value);
    }
}

