/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.item;

import com.mojang.serialization.Codec;
import java.util.List;
import net.dries007.tfc.common.component.item.ItemContainerInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record ItemComponent(ItemStack stack) {
    public static final Codec<ItemComponent> CODEC = ItemStack.CODEC.xmap(ItemComponent::new, ItemComponent::stack);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemComponent> STREAM_CODEC = ItemStack.STREAM_CODEC.map(ItemComponent::new, ItemComponent::stack);
    public static final ItemComponent EMPTY = new ItemComponent(ItemStack.EMPTY);

    public static boolean equals(ItemStack left, ItemStack right) {
        return ItemStack.matches((ItemStack)left, (ItemStack)right);
    }

    public static boolean equals(List<ItemStack> left, List<ItemStack> right) {
        return ItemStack.listMatches(left, right);
    }

    public static int hashCode(ItemStack content) {
        return ItemStack.hashItemAndComponents((ItemStack)content);
    }

    public static int hashCode(List<ItemStack> content) {
        return ItemStack.hashStackList(content);
    }

    public static InsertInfo insert(ItemStack contentInSlot, ItemStack stack, ItemContainerInfo info) {
        if (stack.isEmpty() || !info.canContainItem(stack)) {
            return new InsertInfo(contentInSlot, stack);
        }
        if (!contentInSlot.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)contentInSlot, (ItemStack)stack)) {
            return new InsertInfo(contentInSlot, stack);
        }
        int slotCapacity = Math.min(stack.getMaxStackSize(), info.slotCapacity());
        int slotTotal = contentInSlot.getCount() + stack.getCount();
        ItemStack content = stack.copyWithCount(Math.min(slotCapacity, slotTotal));
        ItemStack remainder = slotTotal > slotCapacity ? stack.copyWithCount(slotTotal - slotCapacity) : ItemStack.EMPTY;
        return new InsertInfo(content, remainder);
    }

    public static ExtractInfo extract(ItemStack content, int amount) {
        if (content.isEmpty()) {
            return new ExtractInfo(content, ItemStack.EMPTY);
        }
        ItemStack remainder = content.getCount() > amount ? content.copyWithCount(content.getCount() - amount) : ItemStack.EMPTY;
        ItemStack extracted = content.getCount() >= amount ? content.copyWithCount(amount) : content;
        return new ExtractInfo(remainder, extracted);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof ItemComponent)) return false;
        ItemComponent that = (ItemComponent)obj;
        if (!ItemComponent.equals(this.stack, that.stack)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return ItemComponent.hashCode(this.stack);
    }

    public record InsertInfo(ItemStack content, ItemStack remainder) {
    }

    public record ExtractInfo(ItemStack content, ItemStack extract) {
    }
}

