/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.mold;

import java.util.Objects;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.fluid.FluidComponent;
import net.dries007.tfc.common.component.fluid.FluidContainer;
import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.HeatContainer;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.util.data.FluidHeat;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class Mold
implements IMold,
FluidContainer,
HeatContainer {
    private final ItemStack stack;
    private final FluidContainerInfo containerInfo;
    private final IHeat heat;
    private FluidComponent fluid;

    public Mold(ItemStack stack, FluidContainerInfo containerInfo) {
        this.stack = stack;
        this.containerInfo = containerInfo;
        this.heat = HeatCapability.mutableView(stack);
        this.fluid = Objects.requireNonNull((FluidComponent)stack.get(TFCComponents.FLUID));
    }

    @Override
    public boolean isMolten() {
        return this.heat.getTemperature() >= FluidHeat.getOrUnknown(this.fluid.content()).meltTemperature();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.fluid.content();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidComponent.FillInfo remainder = FluidComponent.fill(this.fluid.content(), resource, this.containerInfo);
        if (action.execute()) {
            this.updateFluid(remainder.content());
        }
        return remainder.filled();
    }

    @Override
    public FluidStack drainIgnoringTemperature(int maxDrain, IFluidHandler.FluidAction action) {
        FluidComponent.DrainInfo remainder = FluidComponent.drain(this.fluid.content(), maxDrain);
        if (action.execute()) {
            this.updateFluid(remainder.content());
        }
        return remainder.drained();
    }

    public ItemStack getContainer() {
        return this.stack;
    }

    @Override
    public FluidContainerInfo containerInfo() {
        return this.containerInfo;
    }

    @Override
    public IHeat heatContainer() {
        return this.heat;
    }

    private void updateFluid(FluidStack fluid) {
        FluidHeat heat = FluidHeat.getOrUnknown(fluid);
        float heatCapacity = 1.2f + heat.heatCapacity(fluid.getAmount());
        this.fluid = new FluidComponent(fluid);
        this.stack.set(TFCComponents.FLUID, (Object)this.fluid);
        this.heat.setHeatCapacity(heatCapacity);
    }
}

