/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.mold;

import java.util.List;
import java.util.Objects;
import net.dries007.tfc.common.component.CachedMut;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.fluid.FluidContainer;
import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodTraits;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.HeatContainer;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.component.item.ItemComponent;
import net.dries007.tfc.common.component.item.ItemContainer;
import net.dries007.tfc.common.component.item.ItemContainerInfo;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.common.component.mold.VesselComponent;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.util.FluidAlloy;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.data.FluidHeat;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class Vessel
implements IMold,
ItemContainer,
FluidContainer,
HeatContainer {
    private final ItemStack stack;
    private final ContainerInfo containerInfo;
    private final IHeat heat;
    private VesselComponent vessel;

    @Nullable
    public static Vessel get(ItemStack stack) {
        Vessel vessel;
        @Nullable IMold mold = IMold.get(stack);
        return mold instanceof Vessel ? (vessel = (Vessel)mold) : null;
    }

    public Vessel(ItemStack stack, ContainerInfo containerInfo) {
        this.stack = stack;
        this.containerInfo = containerInfo;
        this.vessel = Objects.requireNonNull((VesselComponent)stack.get(TFCComponents.VESSEL));
        this.heat = HeatCapability.mutableView(stack);
    }

    @Override
    public List<ItemStack> contents() {
        return this.vessel.itemContent();
    }

    @Override
    public ContainerInfo containerInfo() {
        return this.containerInfo;
    }

    @Override
    public IHeat heatContainer() {
        return this.heat;
    }

    public ItemStack getContainer() {
        return this.stack;
    }

    @Override
    public boolean isMolten() {
        FluidStack result = this.vessel.fluidContent().getResult();
        @Nullable FluidHeat fluidHeat = FluidHeat.get(result.getFluid());
        return !result.isEmpty() && fluidHeat != null && this.getTemperature() > fluidHeat.meltTemperature();
    }

    public boolean isInventory() {
        return this.getTemperature() == 0.0f && this.vessel.fluidContent().isEmpty();
    }

    public boolean isEmpty() {
        return this.vessel.fluidContent().isEmpty() && Helpers.isEmpty(this.vessel.itemContent());
    }

    public boolean hasFluidContent() {
        return !this.vessel.fluidContent().isEmpty();
    }

    @Override
    public void setTemperature(float temperature) {
        this.heat.setTemperature(temperature);
        this.updateInventoryOnMelt();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.vessel.fluidContent().getResult();
    }

    public int fill(FluidStack input, IFluidHandler.FluidAction action) {
        if (action.simulate()) {
            return this.vessel.fluidContent().fill(input, action, this.containerInfo);
        }
        FluidAlloy newContent = this.vessel.fluidContent().copy();
        int result = newContent.fill(input, action, this.containerInfo);
        this.vessel = this.vessel.with(newContent);
        this.stack.set(TFCComponents.VESSEL, (Object)this.vessel);
        return result;
    }

    @Override
    public FluidStack drainIgnoringTemperature(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.isInventory()) {
            if (action.simulate()) {
                return this.vessel.fluidContent().drain(maxDrain, action);
            }
            FluidAlloy newContent = this.vessel.fluidContent().copy();
            FluidStack result = newContent.drain(maxDrain, action);
            this.updateWith(this.vessel.with(newContent));
            return result;
        }
        return FluidStack.EMPTY;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.isInventory()) {
            this.updateWith(this.vessel.with(slot, FoodCapability.applyTrait(stack.copy(), FoodTraits.PRESERVED).copy()));
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.isInventory()) {
            ItemStack input = FoodCapability.applyTrait(stack.copy(), FoodTraits.PRESERVED);
            ItemComponent.InsertInfo result = ItemComponent.insert(this.vessel.itemContent().get(slot), input, this.containerInfo);
            if (!simulate) {
                this.updateWith(this.vessel.with(slot, result.content()));
            }
            return FoodCapability.removeTrait(result.remainder(), FoodTraits.PRESERVED);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.isInventory()) {
            ItemComponent.ExtractInfo result = ItemComponent.extract(this.vessel.itemContent().get(slot), amount);
            if (!simulate) {
                this.updateWith(this.vessel.with(slot, result.content()));
            }
            return FoodCapability.removeTrait(result.extract(), FoodTraits.PRESERVED);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void onTake(ItemStack stack) {
        FoodCapability.removeTrait(stack, FoodTraits.PRESERVED);
    }

    private void updateInventoryOnMelt() {
        @Nullable VesselComponent updated = null;
        for (int slot = 0; slot < 4; ++slot) {
            ItemStack stack = this.vessel.itemContent().get(slot);
            @Nullable HeatingRecipe recipe = this.getCachedRecipe(slot);
            if (recipe == null || !recipe.isValidTemperature(this.heat.getTemperature())) continue;
            if (updated == null) {
                updated = this.vessel.copyMut();
            }
            ItemStack outputStack = recipe.assembleStacked(stack, this.containerInfo.slotCapacity(), false);
            FluidStack outputFluid = recipe.assembleFluid(stack);
            if (!outputFluid.isEmpty()) {
                outputFluid.setAmount(outputFluid.getAmount() * stack.getCount());
            }
            updated.itemContent().set(slot, outputStack);
            updated.cachedRecipes().get(slot).unload();
            updated.fluidContent().fill(outputFluid, IFluidHandler.FluidAction.EXECUTE, this.containerInfo);
        }
        if (updated != null) {
            this.updateWith(updated);
        }
    }

    private void updateWith(VesselComponent vessel) {
        this.vessel = vessel;
        this.stack.set(TFCComponents.VESSEL, (Object)this.vessel);
        this.updateHeatCapacity();
    }

    private void updateHeatCapacity() {
        FluidAlloy fluid;
        float value = 1.2f;
        float valueFromItems = 0.0f;
        int count = 0;
        for (ItemStack stack : this.vessel.itemContent()) {
            @Nullable IHeat heat = HeatCapability.get(stack);
            if (heat == null) continue;
            count += stack.getCount();
            valueFromItems += heat.getHeatCapacity() * (float)stack.getCount();
        }
        if (count > 0) {
            value += valueFromItems * 0.7f + valueFromItems / (float)count * 0.3f;
        }
        if (!(fluid = this.vessel.fluidContent()).isEmpty()) {
            value += FluidHeat.getOrUnknown(fluid.getResult()).heatCapacity((float)fluid.getAmount() * 0.7f);
        }
        this.heat.setHeatCapacity(value);
    }

    @Nullable
    private HeatingRecipe getCachedRecipe(int slot) {
        CachedMut<HeatingRecipe> cache = this.vessel.cachedRecipes().get(slot);
        if (!cache.isLoaded()) {
            cache.load(HeatingRecipe.getRecipe(this.vessel.itemContent().get(slot)));
        }
        return cache.value();
    }

    public static interface ContainerInfo
    extends ItemContainerInfo,
    FluidContainerInfo {
    }
}

