/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.size;

import java.util.List;
import net.dries007.tfc.common.component.size.IItemSize;
import net.dries007.tfc.common.component.size.ItemSizeDefinition;
import net.dries007.tfc.common.component.size.Size;
import net.dries007.tfc.common.component.size.Weight;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Block;

public final class ItemSizeManager {
    public static final DataManager<ItemSizeDefinition> MANAGER = new DataManager<ItemSizeDefinition>(Helpers.identifier("item_size"), ItemSizeDefinition.CODEC, ItemSizeDefinition.STREAM_CODEC);
    public static final IndirectHashCollection<Item, ItemSizeDefinition> CACHE = IndirectHashCollection.create(r -> RecipeHelpers.itemKeys(r.ingredient()), MANAGER::getValues);
    private static final ItemSizeDefinition TOOL_SIZE = new ItemSizeDefinition(Size.LARGE, Weight.MEDIUM);
    private static final ItemSizeDefinition ARMOR_SIZE = new ItemSizeDefinition(Size.LARGE, Weight.VERY_HEAVY);
    private static final ItemSizeDefinition BLOCK_SIZE = new ItemSizeDefinition(Size.SMALL, Weight.LIGHT);
    private static final ItemSizeDefinition DEFAULT_SIZE = new ItemSizeDefinition(Size.VERY_SMALL, Weight.VERY_LIGHT);

    public static void addTooltipInfo(ItemStack stack, List<Component> text) {
        IItemSize size = ItemSizeManager.get(stack);
        text.add((Component)Component.literal((String)"\u2696 ").append((Component)Helpers.translateEnum(size.getWeight(stack))).append(" \u21f2 ").append((Component)Helpers.translateEnum(size.getSize(stack))).withStyle(ChatFormatting.GRAY));
    }

    public static IItemSize get(ItemStack stack) {
        BlockItem block;
        Block block2;
        Item item = stack.getItem();
        if (item instanceof IItemSize) {
            IItemSize size = (IItemSize)item;
            return size;
        }
        if (item instanceof BlockItem && (block2 = (block = (BlockItem)item).getBlock()) instanceof IItemSize) {
            IItemSize size = (IItemSize)block2;
            return size;
        }
        return ItemSizeManager.getDefinition(stack);
    }

    public static ItemSizeDefinition getDefinition(ItemStack stack) {
        Item item = stack.getItem();
        for (ItemSizeDefinition def : CACHE.getAll(stack.getItem())) {
            if (!def.ingredient().test(stack)) continue;
            return def;
        }
        if (item instanceof TieredItem || item instanceof BucketItem) {
            return TOOL_SIZE;
        }
        if (item instanceof ArmorItem || item instanceof AnimalArmorItem) {
            return ARMOR_SIZE;
        }
        if (item instanceof BlockItem) {
            return BLOCK_SIZE;
        }
        return DEFAULT_SIZE;
    }
}

