/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.size;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.dries007.tfc.network.StreamCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public enum Weight implements StringRepresentable
{
    VERY_LIGHT(64),
    LIGHT(32),
    MEDIUM(16),
    HEAVY(4),
    VERY_HEAVY(1);

    public static final Codec<Weight> CODEC;
    public static final StreamCodec<ByteBuf, Weight> STREAM_CODEC;
    public final int stackSize;
    public final String name = this.name().toLowerCase(Locale.ROOT);

    private Weight(int stackSize) {
        this.stackSize = stackSize;
    }

    public String getSerializedName() {
        return this.name;
    }

    public boolean isSmallerThan(Weight other) {
        return this.stackSize > other.stackSize;
    }

    static {
        CODEC = StringRepresentable.fromValues(Weight::values);
        STREAM_CODEC = StreamCodecs.forEnum(Weight::values);
    }
}

