/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.Nullable;

public class BarrelContainer
extends BlockEntityContainer<BarrelBlockEntity>
implements ButtonHandlerContainer {
    public static BarrelContainer create(BarrelBlockEntity barrel, Inventory playerInv, int windowId) {
        return (BarrelContainer)new BarrelContainer(windowId, barrel).init(playerInv, 12);
    }

    private BarrelContainer(int windowId, BarrelBlockEntity barrel) {
        super((MenuType)TFCContainerTypes.BARREL.get(), windowId, barrel);
    }

    public void clicked(int slot, int button, ClickType clickType, Player player) {
        if (slot >= 0 && slot < 3 && ((Boolean)((BarrelBlockEntity)this.blockEntity).getBlockState().getValue((Property)SealableDeviceBlock.SEALED)).booleanValue()) {
            return;
        }
        super.clicked(slot, button, clickType, player);
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable CompoundTag extraNBT) {
        Level level = ((BarrelBlockEntity)this.blockEntity).getLevel();
        if (level != null) {
            BarrelBlock.toggleSeal(level, ((BarrelBlockEntity)this.blockEntity).getBlockPos(), ((BarrelBlockEntity)this.blockEntity).getBlockState());
        }
    }

    @Override
    protected void addContainerSlots() {
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 0, 35, 20));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 1, 35, 54));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 2, 89, 37));
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        if (((Boolean)((BarrelBlockEntity)this.blockEntity).getBlockState().getValue((Property)BarrelBlock.SEALED)).booleanValue()) {
            return true;
        }
        @Nullable IHeat heat = HeatCapability.get(stack);
        int containerSlot = stack.getCapability(Capabilities.FluidHandler.ITEM) != null && heat != null && heat.getTemperature() == 0.0f ? 0 : 2;
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.moveItemStackTo(stack, containerSlot, containerSlot + 1, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
        };
    }
}

