/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CrucibleContainer
extends BlockEntityContainer<CrucibleBlockEntity> {
    public static CrucibleContainer create(CrucibleBlockEntity crucible, Inventory playerInv, int windowId) {
        return (CrucibleContainer)((Object)new CrucibleContainer(windowId, crucible).init(playerInv, 55));
    }

    private CrucibleContainer(int windowId, CrucibleBlockEntity crucible) {
        super((MenuType)TFCContainerTypes.CRUCIBLE.get(), windowId, crucible);
        this.addDataSlots(crucible.getSyncableData());
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (IMold.get(stack) != null) {
                    if (!this.moveItemStackTo(stack, 9, 10, false)) {
                        yield true;
                    }
                    yield false;
                }
                if (!this.moveItemStackTo(stack, 0, 9, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        for (int slot = 0; slot <= 8; ++slot) {
            int line = slot / 3;
            int column = slot % 3;
            this.addSlot((Slot)new CallbackSlot(this.blockEntity, slot, 26 + column * 18, 82 + line * 18));
        }
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 9, 152, 100));
    }
}

