/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.FireboxBlockEntity;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class FireboxContainer
extends BlockEntityContainer<FireboxBlockEntity> {
    public static FireboxContainer create(FireboxBlockEntity firebox, Inventory playerInventory, int windowId) {
        return (FireboxContainer)((Object)new FireboxContainer(firebox, windowId).init(playerInventory, 36));
    }

    public FireboxContainer(FireboxBlockEntity blockEntity, int windowId) {
        super((MenuType)TFCContainerTypes.FIREBOX.get(), windowId, blockEntity);
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.moveItemStackTo(stack, 0, 16, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        for (int i = 0; i < 16; ++i) {
            this.addSlot((Slot)new CallbackSlot(this.blockEntity, i, 18 * (i % 4) + 62, 18 * (i / 4) + 19));
        }
    }
}

