/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.GrillBlockEntity;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GrillContainer
extends BlockEntityContainer<GrillBlockEntity> {
    public static GrillContainer create(GrillBlockEntity grill, Inventory playerInv, int windowId) {
        return (GrillContainer)((Object)new GrillContainer(grill, windowId).init(playerInv, 20));
    }

    private GrillContainer(GrillBlockEntity grill, int windowId) {
        super((MenuType)TFCContainerTypes.GRILL.get(), windowId, grill);
        this.addDataSlots(grill.getSyncableData());
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (Helpers.isItem(stack, TFCTags.Items.FIREPIT_FUEL)) {
                    if (!this.moveItemStackTo(stack, 0, 4, false)) {
                        yield true;
                    }
                    yield false;
                }
                if (!this.moveItemStackTo(stack, 4, 9, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        int i;
        for (i = 0; i < 4; ++i) {
            this.addSlot((Slot)new CallbackSlot(this.blockEntity, i, 8, 70 - 18 * i));
        }
        for (i = 4; i <= 8; ++i) {
            this.addSlot((Slot)new CallbackSlot(this.blockEntity, i, 62 + (i - 4) * 18, 20));
        }
    }
}

