/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.NestBoxBlockEntity;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.PestContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class NestBoxContainer
extends BlockEntityContainer<NestBoxBlockEntity>
implements PestContainer {
    public static NestBoxContainer create(NestBoxBlockEntity nest, Inventory playerInventory, int windowId) {
        return (NestBoxContainer)new NestBoxContainer(nest, playerInventory, windowId).init(playerInventory);
    }

    public NestBoxContainer(NestBoxBlockEntity blockEntity, Inventory playerInv, int windowId) {
        super((MenuType)TFCContainerTypes.NEST_BOX.get(), windowId, blockEntity);
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.moveItemStackTo(stack, 0, 4, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 0, 71, 23));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 1, 89, 23));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 2, 71, 41));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 3, 89, 41));
    }
}

