/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.PowderkegBlockEntity;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PowderkegContainer
extends BlockEntityContainer<PowderkegBlockEntity>
implements ButtonHandlerContainer {
    public static PowderkegContainer create(PowderkegBlockEntity powderkeg, Inventory playerInv, int windowId) {
        return (PowderkegContainer)new PowderkegContainer(windowId, powderkeg).init(playerInv, 0);
    }

    private PowderkegContainer(int windowId, PowderkegBlockEntity powderkeg) {
        super((MenuType)TFCContainerTypes.POWDERKEG.get(), windowId, powderkeg);
    }

    public void clicked(int slot, int button, ClickType clickType, Player player) {
        if (slot >= 0 && slot < 12 && ((Boolean)((PowderkegBlockEntity)this.blockEntity).getBlockState().getValue((Property)SealableDeviceBlock.SEALED)).booleanValue()) {
            return;
        }
        super.clicked(slot, button, clickType, player);
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable CompoundTag extraNBT) {
        Level level = ((PowderkegBlockEntity)this.blockEntity).getLevel();
        if (level != null) {
            PowderkegBlock.toggleSeal(level, ((PowderkegBlockEntity)this.blockEntity).getBlockPos(), ((PowderkegBlockEntity)this.blockEntity).getBlockState());
        }
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        if (((Boolean)((PowderkegBlockEntity)this.blockEntity).getBlockState().getValue((Property)PowderkegBlock.SEALED)).booleanValue()) {
            return true;
        }
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.moveItemStackTo(stack, 0, 12, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 4; ++x) {
                this.addSlot((Slot)new CallbackSlot(this.blockEntity, x * 3 + y, 25 + x * 18, 19 + y * 18));
            }
        }
    }
}

