/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.TFCChestBlockEntity;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RestrictedChestContainer
extends ChestMenu {
    private final boolean allowAddSlot;

    public static RestrictedChestContainer twoRows(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new RestrictedChestContainer((MenuType)TFCContainerTypes.CHEST_9x2.get(), windowId, inv, 2);
    }

    public static RestrictedChestContainer fourRows(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new RestrictedChestContainer((MenuType)TFCContainerTypes.CHEST_9x4.get(), windowId, inv, 4);
    }

    public RestrictedChestContainer(MenuType<?> type, int id, Inventory inv, int rows) {
        this(type, id, inv, (Container)new SimpleContainer(9 * rows), rows);
    }

    public RestrictedChestContainer(MenuType<?> type, int id, Inventory inv, Container container, int rows) {
        super(type, id, inv, container, rows);
        int col;
        RestrictedChestContainer.checkContainerSize((Container)container, (int)(rows * 9));
        this.allowAddSlot = true;
        for (int row = 0; row < rows; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new RestrictedSlot(container, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        int yOffset = (rows - 4) * 18;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.addSlot(new Slot((Container)inv, col2 + row * 9 + 9, 8 + col2 * 18, 103 + row * 18 + yOffset));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)inv, col, 8 + col * 18, 161 + yOffset));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot instanceof RestrictedSlot) {
            ItemStack item;
            RestrictedSlot rest = (RestrictedSlot)slot;
            if (slot.hasItem() && !rest.mayPlace(item = slot.getItem())) {
                return ItemStack.EMPTY;
            }
        }
        return super.quickMoveStack(player, index);
    }

    protected Slot addSlot(Slot slot) {
        return this.allowAddSlot ? super.addSlot(slot) : slot;
    }

    private static class RestrictedSlot
    extends Slot {
        public RestrictedSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return super.mayPlace(stack) && TFCChestBlockEntity.isValid(stack);
        }
    }
}

