/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import java.util.ArrayList;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.component.Bowl;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodData;
import net.dries007.tfc.common.component.food.IFood;
import net.dries007.tfc.common.component.food.Nutrient;
import net.dries007.tfc.common.component.item.ItemListComponent;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SaladContainer
extends Container
implements ISlotCallback {
    public static final int SLOT_INPUT_START = 0;
    public static final int SLOT_INPUT_END = 4;
    public static final int SLOT_BOWLS = 5;
    public static final int SLOT_OUTPUT = 6;
    private final ItemStackHandler inventory = new InventoryItemHandler(this, this, 7){

        @Override
        protected void onContentsChanged(int slot) {
        }
    };
    private boolean skipOutputUpdates = false;

    public static SaladContainer create(int windowId, Inventory inventory) {
        return (SaladContainer)new SaladContainer(windowId).init(inventory);
    }

    protected SaladContainer(int windowId) {
        super((MenuType)TFCContainerTypes.SALAD.get(), windowId);
    }

    @Override
    public <C extends Container> C init(Inventory playerInventory, int yOffset) {
        Object self = super.init(playerInventory, yOffset);
        assert (this.player != null);
        ItemStack bowl = this.player.getMainHandItem();
        if (Helpers.isItem(bowl, TFCTags.Items.SALAD_BOWLS)) {
            this.inventory.setStackInSlot(5, bowl);
            this.player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        } else {
            bowl = this.player.getOffhandItem();
            if (Helpers.isItem(bowl, TFCTags.Items.SALAD_BOWLS)) {
                this.inventory.setStackInSlot(5, bowl);
                this.player.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
            }
        }
        return self;
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        if (index == 6) {
            this.skipOutputUpdates = true;
        }
        ItemStack result = super.quickMoveStack(player, index);
        this.skipOutputUpdates = false;
        return result;
    }

    @Override
    protected void addContainerSlots() {
        for (int i = 0; i <= 4; ++i) {
            this.addSlot((Slot)new CallbackSlot(this, (IItemHandler)this.inventory, i, 44 + 18 * i, 24));
        }
        this.addSlot((Slot)new CallbackSlot(this, (IItemHandler)this.inventory, 5, 44, 56));
        this.addSlot((Slot)new CallbackSlot(this, (IItemHandler)this.inventory, 6, 116, 56));
    }

    public void removed(Player player) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.isEmpty() || i == 6) continue;
            this.giveItemStackToPlayerOrDrop(player, stack);
        }
        super.removed(player);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return switch (slot) {
            case 5 -> Helpers.isItem(stack, TFCTags.Items.SALAD_BOWLS);
            case 6 -> false;
            default -> Helpers.isItem(stack, TFCTags.Items.USABLE_IN_SALAD);
        };
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        if (!this.skipOutputUpdates) {
            ItemStack bowlStack = this.inventory.getStackInSlot(5);
            if (!bowlStack.isEmpty()) {
                float water = 0.0f;
                float saturation = 0.0f;
                float[] nutrition = new float[Nutrient.TOTAL];
                int ingredientCount = 0;
                int minIngredientCount = 64;
                ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
                for (int i = 0; i <= 4; ++i) {
                    ItemStack ingredient = this.inventory.getStackInSlot(i);
                    @Nullable IFood food = FoodCapability.get(ingredient);
                    if (food == null) continue;
                    ingredients.add(ingredient.copyWithCount(1));
                    if (food.isRotten()) {
                        ingredientCount = 0;
                        break;
                    }
                    water += food.getData().water();
                    saturation += food.getData().saturation();
                    for (Nutrient nutrient : Nutrient.VALUES) {
                        int n = nutrient.ordinal();
                        nutrition[n] = nutrition[n] + food.getData().nutrient(nutrient);
                    }
                    ++ingredientCount;
                    if (ingredient.getCount() >= minIngredientCount) continue;
                    minIngredientCount = ingredient.getCount();
                }
                if (bowlStack.getCount() < minIngredientCount) {
                    minIngredientCount = bowlStack.getCount();
                }
                if (ingredientCount > 0) {
                    float multiplier = 0.75f;
                    water *= 0.75f;
                    saturation *= 0.75f;
                    Nutrient maxNutrient = null;
                    float maxNutrientValue = 0.0f;
                    for (Nutrient nutrient : Nutrient.values()) {
                        int n = nutrient.ordinal();
                        nutrition[n] = nutrition[n] * 0.75f;
                        if (!(nutrition[nutrient.ordinal()] > maxNutrientValue)) continue;
                        maxNutrientValue = nutrition[nutrient.ordinal()];
                        maxNutrient = nutrient;
                    }
                    if (maxNutrient != null) {
                        ItemStack salad = new ItemStack((ItemLike)TFCItems.SALADS.get((Object)maxNutrient).get(), minIngredientCount);
                        FoodCapability.setFoodForDynamicItemOnCreate(salad, new FoodData(4, water, saturation, 0, nutrition, 4.0f));
                        salad.set(TFCComponents.INGREDIENTS, (Object)ItemListComponent.of(ingredients));
                        salad.set(TFCComponents.BOWL, (Object)Bowl.of(bowlStack));
                        this.inventory.setStackInSlot(6, salad);
                        return;
                    }
                }
            }
            if (!this.inventory.getStackInSlot(6).isEmpty()) {
                this.inventory.setStackInSlot(6, ItemStack.EMPTY);
            }
        }
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.CONTAINER -> {
                if (slotIndex != 6) {
                    if (!this.moveItemStackTo(stack, this.containerSlots, this.containerSlots + 36, false)) {
                        yield true;
                    }
                    yield false;
                }
                yield true;
            }
            case Container.IndexType.HOTBAR, Container.IndexType.MAIN_INVENTORY -> !this.moveItemStackTo(stack, 0, 6, false);
        };
    }

    @Override
    public void onSlotTake(Player player, int slot, ItemStack stack) {
        if (slot == 6) {
            int amountCreated = stack.getCount();
            for (int i = 0; i <= 5; ++i) {
                ItemStack inputStack = this.inventory.getStackInSlot(i);
                inputStack.shrink(amountCreated);
            }
        }
    }
}

