/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.wood.ScribingTableBlock;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ScribingTableContainer
extends ItemCombinerMenu {
    private static final int FLUID_INK_COST = 250;
    @Nullable
    private String itemName;

    public static boolean isInkInput(ItemStack stack) {
        return !ScribingTableContainer.getInkFluid(stack).isEmpty() || Helpers.isItem(stack, TFCTags.Items.SCRIBING_INK);
    }

    public static FluidStack getInkFluid(ItemStack stack) {
        @Nullable IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        return fluidHandler == null ? FluidStack.EMPTY : ScribingTableContainer.getInkFluid(fluidHandler);
    }

    public static FluidStack getInkFluid(IFluidHandlerItem handler) {
        for (int tank = 0; tank < handler.getTanks(); ++tank) {
            FluidStack fluidStack = handler.getFluidInTank(tank);
            if (!Helpers.isFluid(fluidStack.getFluid(), TFCTags.Fluids.USABLE_IN_SCRIBING_TABLE) || !ScribingTableContainer.canExtractFluid(handler, fluidStack, 250) && !ScribingTableContainer.canExtractFluid(handler, fluidStack, 1000)) continue;
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public static boolean canExtractFluid(IFluidHandlerItem fluidHandler, FluidStack ink, int amount) {
        FluidStack drainResult = fluidHandler.drain(ink.copyWithAmount(amount), IFluidHandler.FluidAction.SIMULATE);
        return !drainResult.isEmpty() && drainResult.getAmount() == amount;
    }

    public ScribingTableContainer(Inventory playerInv, int windowId) {
        this(playerInv, windowId, ContainerLevelAccess.NULL);
    }

    public ScribingTableContainer(Inventory playerInv, int windowId, ContainerLevelAccess access) {
        super((MenuType)TFCContainerTypes.SCRIBING_TABLE.get(), windowId, playerInv, access);
    }

    protected boolean mayPickup(Player player, boolean hasItem) {
        return player.getAbilities().instabuild || ScribingTableContainer.isInkInput(this.inputSlots.getItem(1));
    }

    protected void onTake(Player player, ItemStack stack) {
        ItemStack resultDye;
        this.inputSlots.setItem(0, ItemStack.EMPTY);
        ItemStack dye = this.inputSlots.getItem(1);
        @Nullable IFluidHandlerItem dyeFluidHandler = (IFluidHandlerItem)dye.getCapability(Capabilities.FluidHandler.ITEM);
        if (dyeFluidHandler != null) {
            FluidStack extracted = dyeFluidHandler.drain(250, IFluidHandler.FluidAction.EXECUTE);
            if (extracted.isEmpty()) {
                dyeFluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            }
            resultDye = dyeFluidHandler.getContainer();
        } else {
            resultDye = dye.copy();
            resultDye.shrink(1);
        }
        this.inputSlots.setItem(1, resultDye);
        this.access.execute((level, pos) -> Helpers.playSound(level, pos, (SoundEvent)TFCSounds.SCRIBING_TABLE.get()));
    }

    protected boolean isValidBlock(BlockState state) {
        return state.getBlock() instanceof ScribingTableBlock;
    }

    public void createResult() {
        ItemStack input = this.inputSlots.getItem(0);
        ItemStack output = input.copy();
        if (StringUtils.isBlank((CharSequence)this.itemName)) {
            if (input.has(DataComponents.CUSTOM_NAME)) {
                output.remove(DataComponents.CUSTOM_NAME);
            } else {
                output = ItemStack.EMPTY;
            }
        } else if (!this.itemName.equals(input.getHoverName().getString())) {
            output.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.itemName));
        } else {
            output = ItemStack.EMPTY;
        }
        this.resultSlots.setItem(0, output);
        this.broadcastChanges();
    }

    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, s -> true).withSlot(1, 76, 47, s -> true).withResultSlot(2, 134, 47).build();
    }

    public void setItemName(String text) {
        this.itemName = text;
        if (this.getSlot(2).hasItem()) {
            ItemStack itemstack = this.getSlot(2).getItem();
            if (StringUtils.isBlank((CharSequence)text)) {
                itemstack.remove(DataComponents.CUSTOM_NAME);
            } else {
                itemstack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.itemName));
            }
        }
        this.createResult();
    }
}

