/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.wood.SewingTableBlock;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.dries007.tfc.common.recipes.SewingRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.input.NonEmptyInput;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SewingTableContainer
extends Container
implements ISlotCallback,
ButtonHandlerContainer {
    public static final int NUM_SLOTS = 5;
    public static final int SLOT_YARN = 0;
    public static final int SLOT_TOOL = 1;
    public static final int SLOT_INPUT_1 = 2;
    public static final int SLOT_INPUT_2 = 3;
    public static final int SLOT_RESULT = 4;
    public static final int BURLAP_ID = 0;
    public static final int WOOL_ID = 1;
    public static final int REMOVE_ID = 2;
    public static final int NEEDLE_ID = 3;
    public static final int PLACE_STITCH_ID = 4;
    public static final int RECIPE_ID = 5;
    public static final int SQUARES_PER_CLOTH = 8;
    public static final int STITCHES_PER_YARN = 16;
    public static final int MAX_SQUARES = 32;
    public static final int MAX_STITCHES = 45;
    public static final int PLACED_SLOTS_OFFSET = 100;
    private final ItemStackHandler inventory;
    private final ContainerLevelAccess access;
    private final DataSlot activeMaterialData = DataSlot.standalone();
    private final SimpleContainerData placedMaterialData = new SimpleContainerData(32);
    private final SimpleContainerData stitchData = new SimpleContainerData(45);
    private final DataSlot burlapCount = DataSlot.standalone();
    private final DataSlot woolCount = DataSlot.standalone();
    private final DataSlot stringCount = DataSlot.standalone();
    private final DataSlot usedBurlap = DataSlot.standalone();
    private final DataSlot usedWool = DataSlot.standalone();
    private final DataSlot usedString = DataSlot.standalone();
    private final Input input = new Input(this);

    public static SewingTableContainer create(Inventory playerInventory, int windowId, ContainerLevelAccess access) {
        return (SewingTableContainer)new SewingTableContainer(windowId, access).init(playerInventory, 30);
    }

    private static boolean isWool(ItemStack item) {
        return Helpers.isItem(item, TFCTags.Items.SEWING_LIGHT_CLOTH);
    }

    private static boolean isBurlap(ItemStack item) {
        return Helpers.isItem(item, TFCTags.Items.SEWING_DARK_CLOTH);
    }

    private static boolean isString(ItemStack item) {
        return Helpers.isItem(item, (TagKey<Item>)Tags.Items.STRINGS);
    }

    private static boolean isNeedle(ItemStack item) {
        return Helpers.isItem(item, TFCTags.Items.SEWING_NEEDLES);
    }

    public SewingTableContainer(int windowId, ContainerLevelAccess access) {
        super((MenuType)TFCContainerTypes.SEWING_TABLE.get(), windowId);
        int i;
        this.access = access;
        this.inventory = new InventoryItemHandler(this, 5);
        this.addDataSlot(this.activeMaterialData).set(-1);
        for (i = 0; i < 32; ++i) {
            this.placedMaterialData.set(i, -1);
        }
        for (i = 0; i < 45; ++i) {
            this.stitchData.set(i, 0);
        }
        this.addDataSlots((ContainerData)this.placedMaterialData);
        this.addDataSlots((ContainerData)this.stitchData);
        this.addDataSlot(this.woolCount).set(0);
        this.addDataSlot(this.burlapCount).set(0);
        this.addDataSlot(this.stringCount).set(0);
        this.addDataSlot(this.usedWool).set(0);
        this.addDataSlot(this.usedBurlap).set(0);
        this.addDataSlot(this.usedString).set(0);
        this.addSlotListener(new ContainerListener(){

            public void slotChanged(AbstractContainerMenu container, int slotIndex, ItemStack stack) {
                if (slotIndex == 0 || slotIndex == 2 || slotIndex == 3) {
                    SewingTableContainer.this.woolCount.set(SewingTableContainer.this.countItem(SewingTableContainer::isWool));
                    SewingTableContainer.this.burlapCount.set(SewingTableContainer.this.countItem(SewingTableContainer::isBurlap));
                    SewingTableContainer.this.stringCount.set(SewingTableContainer.this.inventory.getStackInSlot(0).getCount());
                }
            }

            public void dataChanged(AbstractContainerMenu container, int dataSlotIndex, int value) {
            }
        });
    }

    public void updateResultItem() {
        this.access.execute((level, pos) -> level.getRecipeManager().getRecipeFor((RecipeType)TFCRecipeTypes.SEWING.get(), (RecipeInput)this.input, level).ifPresentOrElse(recipe -> {
            ItemStack result = ((SewingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
            if (result.getItem() != this.inventory.getStackInSlot(4).getItem()) {
                this.inventory.setStackInSlot(4, result);
                this.activeMaterialData.set(-1);
            }
        }, () -> this.inventory.setStackInSlot(4, ItemStack.EMPTY)));
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return SewingTableContainer.isString(stack);
        }
        if (slot == 1) {
            return SewingTableContainer.isNeedle(stack);
        }
        if (slot == 2 || slot == 3) {
            return !SewingTableContainer.isString(stack) && !SewingTableContainer.isNeedle(stack);
        }
        return slot != 4;
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return switch (slot) {
            case 1 -> 1;
            case 0, 2, 3 -> 8;
            default -> 64;
        };
    }

    public int countItem(Predicate<ItemStack> input) {
        ItemStack secondItem;
        int count = 0;
        ItemStack firstItem = this.inventory.getStackInSlot(2);
        if (input.test(firstItem)) {
            count += firstItem.getCount();
        }
        if (input.test(secondItem = this.inventory.getStackInSlot(3))) {
            count += secondItem.getCount();
        }
        return count;
    }

    public void removed(Player player) {
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            if (slot == 4) continue;
            ItemStack stack = this.inventory.getStackInSlot(slot);
            this.giveItemStackToPlayerOrDrop(player, stack);
        }
        super.removed(player);
    }

    @Override
    public boolean stillValid(Player player) {
        return (Boolean)this.access.evaluate((level, pos) -> level.getBlockState(pos).getBlock() instanceof SewingTableBlock && player.position().distanceToSqr(pos.getCenter()) < 64.0, (Object)true);
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable CompoundTag extraNBT) {
        int activeMaterial = this.getActiveMaterial();
        if (buttonID == 0 || buttonID == 3 || buttonID == 1 || buttonID == 2) {
            activeMaterial = buttonID;
        } else if (buttonID - 100 >= 0 && buttonID - 100 < 32 && (activeMaterial == 0 || activeMaterial == 1 || activeMaterial == 2) && activeMaterial != this.getPlacedMaterial(buttonID - 100)) {
            if (activeMaterial == 0) {
                if (this.getBurlapCount() <= 0) {
                    return;
                }
                this.usedBurlap.set(this.usedBurlap.get() + 1);
                this.access.execute((level, pos) -> Helpers.playSound(level, pos, SoundEvents.WOOL_PLACE));
            } else if (activeMaterial == 1) {
                if (this.getWoolCount() <= 0) {
                    return;
                }
                this.usedWool.set(this.usedWool.get() + 1);
                this.access.execute((level, pos) -> Helpers.playSound(level, pos, SoundEvents.WOOL_PLACE));
            } else {
                this.access.execute((level, pos) -> Helpers.playSound(level, pos, SoundEvents.WOOL_BREAK));
            }
            this.placedMaterialData.set(buttonID - 100, activeMaterial == 2 ? -1 : activeMaterial);
        } else if (buttonID == 4 && extraNBT != null && !this.inventory.getStackInSlot(1).isEmpty()) {
            if (this.getYarnCount() <= 0) {
                return;
            }
            this.usedString.set(this.usedString.get() + 1);
            this.stitchData.set(extraNBT.getInt("id"), extraNBT.getInt("stitchType"));
            this.access.execute((level, pos) -> Helpers.playSound(level, pos, SoundEvents.WOOL_HIT));
        }
        this.activeMaterialData.set(activeMaterial);
        this.updateResultItem();
        this.broadcastChanges();
    }

    @Override
    public void onSlotTake(Player player, int slot, ItemStack stack) {
        if (slot == 4) {
            int i;
            int toShrink;
            int woolCount = Mth.ceil((float)((float)this.usedWool.get() / 8.0f));
            int burlapCount = Mth.ceil((float)((float)this.usedBurlap.get() / 8.0f));
            ItemStack stack1 = this.inventory.getStackInSlot(2);
            ItemStack stack2 = this.inventory.getStackInSlot(3);
            if (SewingTableContainer.isWool(stack1)) {
                toShrink = Math.min(woolCount, stack1.getCount());
                stack1.shrink(toShrink);
                woolCount -= toShrink;
            }
            if (woolCount > 0 && SewingTableContainer.isWool(stack2)) {
                stack2.shrink(woolCount);
            }
            if (SewingTableContainer.isBurlap(stack1)) {
                toShrink = Math.min(burlapCount, stack1.getCount());
                stack1.shrink(toShrink);
                burlapCount -= toShrink;
            }
            if (burlapCount > 0 && SewingTableContainer.isBurlap(stack2)) {
                stack2.shrink(burlapCount);
            }
            this.inventory.getStackInSlot(0).shrink(Mth.ceil((float)((float)this.usedString.get() / 16.0f)));
            this.usedWool.set(0);
            this.usedBurlap.set(0);
            this.usedString.set(0);
            this.activeMaterialData.set(-1);
            for (i = 0; i < 32; ++i) {
                this.placedMaterialData.set(i, -1);
            }
            for (i = 0; i < 45; ++i) {
                this.stitchData.set(i, 0);
            }
            Helpers.damageItem(this.inventory.getStackInSlot(1), player.level());
            this.access.execute((level, pos) -> Helpers.playSound(level, pos, SoundEvents.UI_LOOM_TAKE_RESULT));
        }
    }

    public int getBurlapCount() {
        return this.burlapCount.get() * 8 - this.usedBurlap.get();
    }

    public int getWoolCount() {
        return this.woolCount.get() * 8 - this.usedWool.get();
    }

    public int getYarnCount() {
        return this.stringCount.get() * 16 - this.usedString.get();
    }

    public int getActiveMaterial() {
        return this.activeMaterialData.get();
    }

    public int getPlacedMaterial(int slot) {
        return this.placedMaterialData.get(slot);
    }

    public int getStitchAt(int slot) {
        return this.stitchData.get(slot);
    }

    public boolean canPickup(int slot) {
        return this.canPickup(this.inventory.getStackInSlot(slot));
    }

    public boolean canPickup(ItemStack item) {
        if (SewingTableContainer.isWool(item) && this.usedWool.get() > 0) {
            return false;
        }
        if (SewingTableContainer.isBurlap(item) && this.usedBurlap.get() > 0) {
            return false;
        }
        if (SewingTableContainer.isString(item) && this.usedString.get() > 0) {
            return false;
        }
        return !SewingTableContainer.isNeedle(item) || this.usedString.get() <= 0;
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.moveItemStackTo(stack, 0, 5, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        super.addContainerSlots();
        this.addSlot((Slot)new SewingInputSlot(this, (IItemHandler)this.inventory, 0, 8, 83));
        this.addSlot((Slot)new SewingInputSlot(this, (IItemHandler)this.inventory, 1, 26, 83));
        this.addSlot((Slot)new SewingInputSlot(this, (IItemHandler)this.inventory, 2, 62, 83));
        this.addSlot((Slot)new SewingInputSlot(this, (IItemHandler)this.inventory, 3, 80, 83));
        this.addSlot((Slot)new CallbackSlot(this, (IItemHandler)this.inventory, 4, 152, 83));
    }

    public record Input(SewingTableContainer container) implements NonEmptyInput
    {
        public boolean stitchesMatch(SewingRecipe recipe) {
            if (this.container.stitchData.getCount() != 45) {
                return false;
            }
            for (int i = 0; i < 45; ++i) {
                if (recipe.getStitch(i) == (this.container.stitchData.get(i) == 1)) continue;
                return false;
            }
            return true;
        }

        public boolean squaresMatch(SewingRecipe recipe) {
            if (this.container.placedMaterialData.getCount() != 32) {
                return false;
            }
            for (int i = 0; i < 32; ++i) {
                if (recipe.getSquare(i) == this.container.placedMaterialData.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    public static class SewingInputSlot
    extends CallbackSlot {
        private final SewingTableContainer callback;

        public SewingInputSlot(SewingTableContainer callback, IItemHandler inventory, int index, int x, int y) {
            super(callback, inventory, index, x, y);
            this.callback = callback;
        }

        public boolean mayPickup(Player player) {
            return this.callback.canPickup(this.getItem()) && super.mayPickup(player);
        }
    }
}

