/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodTraits;
import net.dries007.tfc.common.component.mold.Vessel;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerCopySlot;
import org.jetbrains.annotations.Nullable;

public class SmallVesselInventoryContainer
extends ItemStackContainer {
    @Nullable
    private final Vessel vessel;

    public static SmallVesselInventoryContainer create(ItemStack stack, InteractionHand hand, int slot, Inventory playerInv, int windowId) {
        return (SmallVesselInventoryContainer)((Object)new SmallVesselInventoryContainer(stack, hand, slot, playerInv, windowId).init(playerInv));
    }

    private SmallVesselInventoryContainer(ItemStack stack, InteractionHand hand, int slot, Inventory playerInv, int windowId) {
        super((MenuType)TFCContainerTypes.SMALL_VESSEL_INVENTORY.get(), windowId, playerInv, stack, hand, slot);
        this.vessel = Vessel.get(stack);
    }

    @Override
    public boolean stillValid(Player player) {
        return this.vessel != null && this.vessel.isInventory() && super.stillValid(player);
    }

    @Override
    public void setCarried(ItemStack stack) {
        if (this.vessel != null) {
            this.vessel.onTake(stack);
        }
        super.setCarried(stack);
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.moveItemStackTo(stack, 0, 4, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> {
                boolean result;
                FoodCapability.removeTrait(stack, FoodTraits.PRESERVED);
                boolean v1 = result = !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
                if (result) {
                    FoodCapability.applyTrait(stack, FoodTraits.PRESERVED);
                }
                yield result;
            }
        };
    }

    @Override
    protected void addContainerSlots() {
        if (this.vessel != null) {
            this.addSlot((Slot)new ItemHandlerCopySlot((IItemHandler)this.vessel, 0, 71, 23));
            this.addSlot((Slot)new ItemHandlerCopySlot((IItemHandler)this.vessel, 1, 89, 23));
            this.addSlot((Slot)new ItemHandlerCopySlot((IItemHandler)this.vessel, 2, 71, 41));
            this.addSlot((Slot)new ItemHandlerCopySlot((IItemHandler)this.vessel, 3, 89, 41));
        }
    }
}

