/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.container.AnvilContainer;
import net.dries007.tfc.common.container.AnvilPlanContainer;
import net.dries007.tfc.common.container.BarrelContainer;
import net.dries007.tfc.common.container.BlastFurnaceContainer;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.CharcoalForgeContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.CrucibleContainer;
import net.dries007.tfc.common.container.FireboxContainer;
import net.dries007.tfc.common.container.FirepitContainer;
import net.dries007.tfc.common.container.GrillContainer;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.common.container.ItemStackContainerProvider;
import net.dries007.tfc.common.container.KnappingContainer;
import net.dries007.tfc.common.container.LargeVesselContainer;
import net.dries007.tfc.common.container.MoldLikeAlloyContainer;
import net.dries007.tfc.common.container.NestBoxContainer;
import net.dries007.tfc.common.container.PotContainer;
import net.dries007.tfc.common.container.PowderkegContainer;
import net.dries007.tfc.common.container.RestrictedChestContainer;
import net.dries007.tfc.common.container.SaladContainer;
import net.dries007.tfc.common.container.ScribingTableContainer;
import net.dries007.tfc.common.container.SewingTableContainer;
import net.dries007.tfc.common.container.SmallVesselInventoryContainer;
import net.dries007.tfc.common.container.TFCWorkbenchContainer;
import net.dries007.tfc.util.data.KnappingType;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class TFCContainerTypes {
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"tfc");
    public static final Id<Container> CALENDAR = TFCContainerTypes.register("calendar", (windowId, inv, data) -> Container.create((MenuType)CALENDAR.get(), windowId, inv));
    public static final Id<Container> NUTRITION = TFCContainerTypes.register("nutrition", (windowId, inv, data) -> Container.create((MenuType)NUTRITION.get(), windowId, inv));
    public static final Id<Container> CLIMATE = TFCContainerTypes.register("climate", (windowId, inv, data) -> Container.create((MenuType)CLIMATE.get(), windowId, inv));
    public static final Id<SaladContainer> SALAD = TFCContainerTypes.register("salad", (windowId, inv, data) -> SaladContainer.create(windowId, inv));
    public static final Id<TFCWorkbenchContainer> WORKBENCH = TFCContainerTypes.register("workbench", (windowId, inv, data) -> new TFCWorkbenchContainer(windowId, inv));
    public static final Id<ScribingTableContainer> SCRIBING_TABLE = TFCContainerTypes.register("scribing_table", (windowId, inv, data) -> new ScribingTableContainer(inv, windowId));
    public static final Id<SewingTableContainer> SEWING_TABLE = TFCContainerTypes.register("sewing_table", (windowId, inv, data) -> SewingTableContainer.create(inv, windowId, ContainerLevelAccess.NULL));
    public static final Id<FirepitContainer> FIREPIT = TFCContainerTypes.registerBlock("firepit", TFCBlockEntities.FIREPIT, FirepitContainer::create);
    public static final Id<GrillContainer> GRILL = TFCContainerTypes.registerBlock("grill", TFCBlockEntities.GRILL, GrillContainer::create);
    public static final Id<PotContainer> POT = TFCContainerTypes.registerBlock("pot", TFCBlockEntities.POT, PotContainer::create);
    public static final Id<CharcoalForgeContainer> CHARCOAL_FORGE = TFCContainerTypes.registerBlock("charcoal_forge", TFCBlockEntities.CHARCOAL_FORGE, CharcoalForgeContainer::create);
    public static final Id<FireboxContainer> FIREBOX = TFCContainerTypes.registerBlock("firebox", TFCBlockEntities.FIREBOX, FireboxContainer::create);
    public static final Id<CrucibleContainer> CRUCIBLE = TFCContainerTypes.registerBlock("crucible", TFCBlockEntities.CRUCIBLE, CrucibleContainer::create);
    public static final Id<BarrelContainer> BARREL = TFCContainerTypes.registerBlock("barrel", TFCBlockEntities.BARREL, BarrelContainer::create);
    public static final Id<PowderkegContainer> POWDERKEG = TFCContainerTypes.registerBlock("powderkeg", TFCBlockEntities.POWDERKEG, PowderkegContainer::create);
    public static final Id<NestBoxContainer> NEST_BOX = TFCContainerTypes.registerBlock("nest_box", TFCBlockEntities.NEST_BOX, NestBoxContainer::create);
    public static final Id<LargeVesselContainer> LARGE_VESSEL = TFCContainerTypes.registerBlock("large_vessel", TFCBlockEntities.LARGE_VESSEL, LargeVesselContainer::create);
    public static final Id<AnvilContainer> ANVIL = TFCContainerTypes.registerBlock("anvil", TFCBlockEntities.ANVIL, AnvilContainer::create);
    public static final Id<AnvilPlanContainer> ANVIL_PLAN = TFCContainerTypes.registerBlock("anvil_plan", TFCBlockEntities.ANVIL, AnvilPlanContainer::create);
    public static final Id<BlastFurnaceContainer> BLAST_FURNACE = TFCContainerTypes.registerBlock("blast_furnace", TFCBlockEntities.BLAST_FURNACE, BlastFurnaceContainer::create);
    public static final Id<RestrictedChestContainer> CHEST_9x2 = TFCContainerTypes.register("chest_9x2", RestrictedChestContainer::twoRows);
    public static final Id<RestrictedChestContainer> CHEST_9x4 = TFCContainerTypes.register("chest_9x4", RestrictedChestContainer::fourRows);
    public static final Id<SmallVesselInventoryContainer> SMALL_VESSEL_INVENTORY = TFCContainerTypes.registerItem("small_vessel_inventory", SmallVesselInventoryContainer::create);
    public static final Id<MoldLikeAlloyContainer> MOLD_LIKE_ALLOY = TFCContainerTypes.registerItem("mold_like_alloy", MoldLikeAlloyContainer::create);
    public static final Id<KnappingContainer> KNAPPING = TFCContainerTypes.register("knapping", (windowId, playerInventory, buffer) -> {
        KnappingType knappingType = KnappingType.MANAGER.getOrThrow(buffer.readResourceLocation());
        ItemStackContainerProvider.Info info = ItemStackContainerProvider.read((FriendlyByteBuf)buffer, playerInventory);
        return KnappingContainer.create(info.stack(), knappingType, info.hand(), info.slot(), playerInventory, windowId);
    });

    private static <T extends InventoryBlockEntity<?>, C extends BlockEntityContainer<T>> Id<C> registerBlock(String name, Supplier<BlockEntityType<T>> type, BlockEntityContainer.Factory<T, C> factory) {
        return new Id<C>(RegistrationHelpers.registerBlockEntityContainer(CONTAINERS, name, type, factory));
    }

    private static <C extends ItemStackContainer> Id<C> registerItem(String name, ItemStackContainer.Factory<C> factory) {
        return new Id<C>(RegistrationHelpers.registerItemStackContainer(CONTAINERS, name, factory));
    }

    private static <C extends AbstractContainerMenu> Id<C> register(String name, IContainerFactory<C> factory) {
        return new Id<C>(RegistrationHelpers.registerContainer(CONTAINERS, name, factory));
    }

    public record Id<T extends AbstractContainerMenu>(DeferredHolder<MenuType<?>, MenuType<T>> holder) implements RegistryHolder<MenuType<?>, MenuType<T>>
    {
    }
}

