/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.effect;

import java.util.function.Supplier;
import net.dries007.tfc.common.effect.TFCEffects;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public class TFCMobEffect
extends MobEffect {
    public TFCMobEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplitude) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this == TFCEffects.PINNED.get()) {
                player.setForcedPose(Pose.SLEEPING);
            } else if (this == TFCEffects.THIRST.get()) {
                IPlayerInfo info = IPlayerInfo.get(player);
                if (info.getThirst() > 0.05f) {
                    info.addThirst(-0.02f * (float)(amplitude + 1));
                }
            } else if (this == TFCEffects.EXHAUSTED.get()) {
                player.causeFoodExhaustion(0.06666667f * TFCConfig.SERVER.passiveExhaustionModifier.get().floatValue() * 0.25f);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplitude) {
        return this == TFCEffects.PINNED.get() || this.tickForAmplitude(TFCEffects.THIRST, 50, amplitude) || this.tick(TFCEffects.EXHAUSTED, duration % 20 == 0);
    }

    private boolean tick(Supplier<MobEffect> check, boolean accepted) {
        return this == check.get() && accepted;
    }

    private boolean tickForAmplitude(Supplier<MobEffect> check, int base, int amplitude) {
        if (this == check.get()) {
            int ticker = base >> amplitude;
            return ticker <= 0 || amplitude % ticker == 0;
        }
        return false;
    }
}

