/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.data.DataManager;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.placement.ClimatePlacement;

public record Fauna(int chance, int distanceBelowSeaLevel, ClimatePlacement climate, boolean solidGround, int maxBrightness, List<Month> months) {
    public static final Codec<Fauna> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.optionalFieldOf("chance", (Object)1).forGetter(c -> c.chance), (App)Codec.INT.optionalFieldOf("distance_below_sea_level", (Object)-1).forGetter(c -> c.distanceBelowSeaLevel), (App)ClimatePlacement.CODEC.forGetter(c -> c.climate), (App)Codec.BOOL.optionalFieldOf("solid_ground", (Object)false).forGetter(c -> c.solidGround), (App)Codec.INT.optionalFieldOf("max_brightness", (Object)-1).forGetter(c -> c.maxBrightness), (App)Month.CODEC.listOf().optionalFieldOf("months", Collections.emptyList()).forGetter(c -> c.months)).apply((Applicative)i, Fauna::new));
    public static final DataManager<Fauna> MANAGER = new DataManager<Fauna>(Helpers.identifier("fauna"), CODEC);

    public static final class Builder {
        float minTemperature = Float.NEGATIVE_INFINITY;
        float maxTemperature = Float.POSITIVE_INFINITY;
        float minRainfall = Float.NEGATIVE_INFINITY;
        float maxRainfall = Float.POSITIVE_INFINITY;
        float minRainVariance = -1.0f;
        float maxRainVariance = 1.0f;
        boolean rainVarianceAbsolute = false;
        int minForest = 0;
        int maxForest = 4;
        List<ForestType> forests = new ArrayList<ForestType>();
        int minElevation = -64;
        int maxElevation = 320;
        boolean fuzzy = false;
        boolean ignoreRivers = false;
        int chance = 1;
        int distanceBelowSeaLevel = -1;
        boolean solidGround = false;
        int maxBrightness = -1;
        List<Month> months = new ArrayList<Month>();

        public Builder minTemperature(float min) {
            return this.temperature(min, Float.POSITIVE_INFINITY);
        }

        public Builder maxTemperature(float max) {
            return this.temperature(Float.NEGATIVE_INFINITY, max);
        }

        public Builder temperature(float min, float max) {
            this.minTemperature = min;
            this.maxTemperature = max;
            return this;
        }

        public Builder minGroundwater(float min) {
            return this.groundwater(min, Float.POSITIVE_INFINITY);
        }

        public Builder maxGroundwater(float max) {
            return this.groundwater(Float.NEGATIVE_INFINITY, max);
        }

        public Builder groundwater(float min, float max) {
            this.minRainfall = min;
            this.maxRainfall = max;
            return this;
        }

        public Builder minRainVariance(float min) {
            return this.rainVariance(min, 1.0f, false);
        }

        public Builder maxRainVariance(float max) {
            return this.rainVariance(-1.0f, max, false);
        }

        public Builder rainVariance(float min, float max, boolean isAbsolute) {
            this.minRainfall = min;
            this.maxRainfall = max;
            this.rainVarianceAbsolute = isAbsolute;
            return this;
        }

        public Builder minForest(int min) {
            return this.forest(min, 4);
        }

        public Builder maxForest(int max) {
            return this.forest(0, max);
        }

        public Builder forest(int min, int max) {
            this.minForest = min;
            this.maxForest = max;
            return this;
        }

        public Builder forestType(ForestType ... types) {
            this.forests.addAll(List.of(types));
            return this;
        }

        public Builder minElevation(int min) {
            return this.elevation(min, 320);
        }

        public Builder maxElevation(int max) {
            return this.elevation(-64, max);
        }

        public Builder elevation(int min, int max) {
            this.minElevation = min;
            this.maxElevation = max;
            return this;
        }

        public Builder months(List<Month> months) {
            this.months.addAll(months);
            return this;
        }

        public Builder chance(int value) {
            this.chance = value;
            return this;
        }

        public Builder distanceBelowSeaLevel(int value) {
            this.distanceBelowSeaLevel = value;
            return this;
        }

        public Builder maxBrightness(int value) {
            this.maxBrightness = value;
            return this;
        }

        public Builder fuzzy() {
            this.fuzzy = true;
            return this;
        }

        public Builder solid() {
            this.solidGround = true;
            return this;
        }

        public Builder ignoreRivers() {
            this.ignoreRivers = true;
            return this;
        }

        public Fauna build() {
            return new Fauna(this.chance, this.distanceBelowSeaLevel, new ClimatePlacement(this.minTemperature, this.maxTemperature, this.minRainfall, this.maxRainfall, this.minRainVariance, this.maxRainVariance, this.rainVarianceAbsolute, this.minForest, this.maxForest, this.forests, this.minElevation, this.maxElevation, this.fuzzy, this.ignoreRivers), this.solidGround, this.maxBrightness, this.months);
        }
    }
}

