/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import net.dries007.tfc.common.TFCDamageTypes;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public interface Pluckable {
    public static final int PLUCKING_COOLDOWN = 1000;

    public long getLastPluckedTick();

    public void setLastPluckedTick(long var1);

    /*
     * Enabled aggressive block sorting
     */
    default public boolean pluck(Player player, InteractionHand hand, LivingEntity entity) {
        long remainingTicks;
        Level level = entity.level();
        if (level.isClientSide) return false;
        if (hand == InteractionHand.OFF_HAND) {
            return false;
        }
        if (!player.getItemInHand(hand).isEmpty()) return false;
        if (!player.isShiftKeyDown()) return false;
        if (!(entity.getHealth() / entity.getMaxHealth() > 0.15001f)) return false;
        long lastPlucked = this.getLastPluckedTick();
        if (lastPlucked > 0L && (remainingTicks = lastPlucked + 1000L - Calendars.SERVER.getTicks()) > 0L) {
            player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.animal.cannot_pluck", (Object[])new Object[]{Calendars.SERVER.getTimeDelta(remainingTicks)}), true);
            return false;
        }
        if (entity.getHealth() / entity.getMaxHealth() <= 0.15f) {
            player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.animal.cannot_pluck_old_or_sick"), true);
            return false;
        }
        ItemStack feather = new ItemStack((ItemLike)Items.FEATHER, Mth.nextInt((RandomSource)entity.getRandom(), (int)1, (int)3));
        if (!(entity instanceof TFCAnimalProperties)) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)feather);
            TFCDamageTypes.pluck((Entity)entity, entity.getMaxHealth() * 0.15f, null);
            this.setLastPluckedTick(Calendars.SERVER.getTicks());
            return true;
        }
        TFCAnimalProperties properties = (TFCAnimalProperties)entity;
        if (properties.getAgeType() == Age.ADULT && properties.getUses() < properties.getUsesToElderly()) {
            AnimalProductEvent event = new AnimalProductEvent(level, entity.blockPosition(), player, properties, feather, ItemStack.EMPTY, 1);
            if (!((AnimalProductEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                TFCDamageTypes.pluck((Entity)entity, entity.getMaxHealth() * 0.15f, null);
                properties.addUses(event.getUses());
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)event.getProduct());
            }
            this.setLastPluckedTick(Calendars.SERVER.getTicks());
            return true;
        }
        player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.animal.cannot_pluck_old_or_sick"), true);
        return false;
    }
}

