/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.dries007.tfc.common.entities.ai.prey.TFCOcelot;
import net.dries007.tfc.common.entities.aquatic.AmphibiousAnimal;
import net.dries007.tfc.common.entities.aquatic.AquaticCritter;
import net.dries007.tfc.common.entities.aquatic.Fish;
import net.dries007.tfc.common.entities.aquatic.FreshwaterFish;
import net.dries007.tfc.common.entities.aquatic.Jellyfish;
import net.dries007.tfc.common.entities.aquatic.LeopardSeal;
import net.dries007.tfc.common.entities.aquatic.Manatee;
import net.dries007.tfc.common.entities.aquatic.Octopoteuthis;
import net.dries007.tfc.common.entities.aquatic.Penguin;
import net.dries007.tfc.common.entities.aquatic.TFCCod;
import net.dries007.tfc.common.entities.aquatic.TFCDolphin;
import net.dries007.tfc.common.entities.aquatic.TFCPufferfish;
import net.dries007.tfc.common.entities.aquatic.TFCSquid;
import net.dries007.tfc.common.entities.aquatic.TFCTropicalFish;
import net.dries007.tfc.common.entities.aquatic.TFCTurtle;
import net.dries007.tfc.common.entities.livestock.DairyAnimal;
import net.dries007.tfc.common.entities.livestock.Mammal;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.dries007.tfc.common.entities.livestock.WoolyAnimal;
import net.dries007.tfc.common.entities.livestock.horse.TFCDonkey;
import net.dries007.tfc.common.entities.livestock.horse.TFCHorse;
import net.dries007.tfc.common.entities.livestock.horse.TFCMule;
import net.dries007.tfc.common.entities.livestock.pet.Dog;
import net.dries007.tfc.common.entities.livestock.pet.TFCCat;
import net.dries007.tfc.common.entities.misc.GlowArrow;
import net.dries007.tfc.common.entities.misc.HoldingMinecart;
import net.dries007.tfc.common.entities.misc.Seat;
import net.dries007.tfc.common.entities.misc.TFCBoat;
import net.dries007.tfc.common.entities.misc.TFCChestBoat;
import net.dries007.tfc.common.entities.misc.TFCFallingBlockEntity;
import net.dries007.tfc.common.entities.misc.TFCFishingHook;
import net.dries007.tfc.common.entities.misc.TFCMinecartChest;
import net.dries007.tfc.common.entities.misc.ThrownJavelin;
import net.dries007.tfc.common.entities.predator.AmphibiousPredator;
import net.dries007.tfc.common.entities.predator.FelinePredator;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.common.entities.prey.Pest;
import net.dries007.tfc.common.entities.prey.Prey;
import net.dries007.tfc.common.entities.prey.RammingPrey;
import net.dries007.tfc.common.entities.prey.TFCFox;
import net.dries007.tfc.common.entities.prey.TFCFrog;
import net.dries007.tfc.common.entities.prey.TFCPanda;
import net.dries007.tfc.common.entities.prey.TFCRabbit;
import net.dries007.tfc.common.entities.prey.WildAnimal;
import net.dries007.tfc.common.entities.prey.WingedPrey;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TFCEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"tfc");
    public static final Id<TFCFallingBlockEntity> FALLING_BLOCK = TFCEntities.register("falling_block", EntityType.Builder.of(TFCFallingBlockEntity::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.98f));
    public static final Id<TFCFishingHook> FISHING_BOBBER = TFCEntities.register("fishing_bobber", EntityType.Builder.of(TFCFishingHook::new, (MobCategory)MobCategory.MISC).noSave().noSummon().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(5));
    public static final Id<GlowArrow> GLOW_ARROW = TFCEntities.register("glow_arrow", EntityType.Builder.of(GlowArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20));
    public static final Id<ThrownJavelin> THROWN_JAVELIN = TFCEntities.register("thrown_javelin", EntityType.Builder.of(ThrownJavelin::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20));
    public static final Id<Seat> SEAT = TFCEntities.register("seat", EntityType.Builder.of(Seat::new, (MobCategory)MobCategory.MISC).sized(0.1f, 0.1f).clientTrackingRange(4).updateInterval(20));
    public static final Id<TFCMinecartChest> CHEST_MINECART = TFCEntities.register("chest_minecart", EntityType.Builder.of(TFCMinecartChest::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.7f).clientTrackingRange(8));
    public static final Id<HoldingMinecart> HOLDING_MINECART = TFCEntities.register("holding_minecart", EntityType.Builder.of(HoldingMinecart::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.7f).clientTrackingRange(8));
    public static final Map<Wood, Id<TFCChestBoat>> CHEST_BOATS = Helpers.mapOf(Wood.class, wood -> TFCEntities.register("chest_boat/" + wood.name(), EntityType.Builder.of((type, level) -> new TFCChestBoat((EntityType<? extends Boat>)type, level, TFCItems.BOATS.get(wood)), (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10)));
    public static final Map<Wood, Id<TFCBoat>> BOATS = Helpers.mapOf(Wood.class, wood -> TFCEntities.register("boat/" + wood.name(), EntityType.Builder.of((type, level) -> new TFCBoat((EntityType<? extends Boat>)type, level, (Supplier<EntityType<TFCChestBoat>>)CHEST_BOATS.get(wood), TFCItems.BOATS.get(wood)), (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10)));
    public static final Map<Fish, Id<FreshwaterFish>> FRESHWATER_FISH = Helpers.mapOf(Fish.class, fish -> TFCEntities.register(fish.getSerializedName(), EntityType.Builder.of((type, level) -> new FreshwaterFish((EntityType<? extends FreshwaterFish>)type, level, TFCSounds.FRESHWATER_FISHES.get(fish), TFCItems.FRESHWATER_FISH_BUCKETS.get(fish)), (MobCategory)MobCategory.WATER_AMBIENT).sized(fish.getWidth(), fish.getHeight()).clientTrackingRange(4)));
    public static final Id<TFCCod> COD = TFCEntities.register("cod", EntityType.Builder.of(TFCCod::new, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.5f, 0.3f).eyeHeight(0.26f).clientTrackingRange(4));
    public static final Id<TFCTropicalFish> TROPICAL_FISH = TFCEntities.register("tropical_fish", EntityType.Builder.of(TFCTropicalFish::new, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.5f, 0.4f).eyeHeight(0.26f).clientTrackingRange(4));
    public static final Id<TFCPufferfish> PUFFERFISH = TFCEntities.register("pufferfish", EntityType.Builder.of(TFCPufferfish::new, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.7f, 0.7f).eyeHeight(0.455f).clientTrackingRange(4));
    public static final Id<Jellyfish> JELLYFISH = TFCEntities.register("jellyfish", EntityType.Builder.of(Jellyfish::new, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.5f, 0.5f).eyeHeight(0.26f).clientTrackingRange(4));
    public static final Id<AquaticCritter> ISOPOD = TFCEntities.register("isopod", EntityType.Builder.of(AquaticCritter::salty, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.5f, 0.3f).eyeHeight(0.26f).clientTrackingRange(4));
    public static final Id<AquaticCritter> LOBSTER = TFCEntities.register("lobster", EntityType.Builder.of(AquaticCritter::salty, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.5f, 0.3f).eyeHeight(0.26f).clientTrackingRange(4));
    public static final Id<AquaticCritter> CRAYFISH = TFCEntities.register("crayfish", EntityType.Builder.of(AquaticCritter::fresh, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.5f, 0.3f).eyeHeight(0.26f).clientTrackingRange(4));
    public static final Id<AquaticCritter> HORSESHOE_CRAB = TFCEntities.register("horseshoe_crab", EntityType.Builder.of(AquaticCritter::salty, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.5f, 0.3f).eyeHeight(0.26f).clientTrackingRange(4));
    public static final Id<TFCDolphin> DOLPHIN = TFCEntities.register("dolphin", EntityType.Builder.of(TFCDolphin::new, (MobCategory)MobCategory.WATER_CREATURE).sized(0.9f, 0.6f).eyeHeight(0.3f));
    public static final Id<TFCDolphin> ORCA = TFCEntities.register("orca", EntityType.Builder.of(TFCDolphin::new, (MobCategory)MobCategory.WATER_CREATURE).sized(1.1f, 1.0f).eyeHeight(0.3f));
    public static final Id<Manatee> MANATEE = TFCEntities.register("manatee", EntityType.Builder.of(Manatee::new, (MobCategory)MobCategory.WATER_CREATURE).sized(1.5f, 1.2f).eyeHeight(0.3f));
    public static final Id<TFCSquid> SQUID = TFCEntities.register("squid", EntityType.Builder.of(TFCSquid::new, (MobCategory)MobCategory.WATER_CREATURE).sized(0.8f, 0.8f).eyeHeight(0.4f).clientTrackingRange(8));
    public static final Id<Octopoteuthis> OCTOPOTEUTHIS = TFCEntities.register("octopoteuthis", EntityType.Builder.of(Octopoteuthis::new, (MobCategory)MobCategory.UNDERGROUND_WATER_CREATURE).sized(0.8f, 0.8f).eyeHeight(0.4f).clientTrackingRange(8));
    public static final Id<TFCTurtle> TURTLE = TFCEntities.register("turtle", EntityType.Builder.of(TFCTurtle::new, (MobCategory)MobCategory.CREATURE).sized(0.8f, 0.3f).clientTrackingRange(10));
    public static final Id<Penguin> PENGUIN = TFCEntities.register("penguin", EntityType.Builder.of(Penguin::new, (MobCategory)MobCategory.CREATURE).sized(0.3f, 0.6f).clientTrackingRange(10));
    public static final Id<LeopardSeal> LEOPARD_SEAL = TFCEntities.register("leopard_seal", EntityType.Builder.of(LeopardSeal::new, (MobCategory)MobCategory.CREATURE).sized(1.2f, 0.7f).clientTrackingRange(10));
    public static final Id<TFCFrog> FROG = TFCEntities.register("frog", EntityType.Builder.of(TFCFrog::new, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.5f).clientTrackingRange(10));
    public static final Id<Predator> POLAR_BEAR = TFCEntities.register("polar_bear", EntityType.Builder.of(Predator::createBear, (MobCategory)MobCategory.CREATURE).immuneTo(new Block[]{Blocks.POWDER_SNOW}).sized(1.4f, 1.4f).clientTrackingRange(10));
    public static final Id<Predator> GRIZZLY_BEAR = TFCEntities.register("grizzly_bear", EntityType.Builder.of(Predator::createBear, (MobCategory)MobCategory.CREATURE).immuneTo(new Block[]{Blocks.POWDER_SNOW}).sized(1.4f, 1.6f).clientTrackingRange(10));
    public static final Id<Predator> BLACK_BEAR = TFCEntities.register("black_bear", EntityType.Builder.of(Predator::createBear, (MobCategory)MobCategory.CREATURE).immuneTo(new Block[]{Blocks.POWDER_SNOW}).sized(1.2f, 1.3f).clientTrackingRange(10));
    public static final Id<FelinePredator> COUGAR = TFCEntities.register("cougar", EntityType.Builder.of(FelinePredator::createCougar, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.1f).clientTrackingRange(10));
    public static final Id<FelinePredator> PANTHER = TFCEntities.register("panther", EntityType.Builder.of(FelinePredator::createCougar, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.1f).clientTrackingRange(10));
    public static final Id<FelinePredator> LION = TFCEntities.register("lion", EntityType.Builder.of(FelinePredator::createLion, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.2f).clientTrackingRange(10));
    public static final Id<FelinePredator> SABERTOOTH = TFCEntities.register("sabertooth", EntityType.Builder.of(FelinePredator::createSabertooth, (MobCategory)MobCategory.CREATURE).sized(1.1f, 1.3f).clientTrackingRange(10));
    public static final Id<FelinePredator> TIGER = TFCEntities.register("tiger", EntityType.Builder.of(FelinePredator::createTiger, (MobCategory)MobCategory.CREATURE).sized(1.1f, 1.3f).clientTrackingRange(10));
    public static final Id<AmphibiousPredator> CROCODILE = TFCEntities.register("crocodile", EntityType.Builder.of(AmphibiousPredator::createCrocodile, (MobCategory)MobCategory.CREATURE).sized(1.8f, 0.8f).clientTrackingRange(10));
    public static final Id<PackPredator> WOLF = TFCEntities.register("wolf", EntityType.Builder.of(PackPredator::createWolf, (MobCategory)MobCategory.CREATURE).sized(0.65f, 0.9f).eyeHeight(0.68f).clientTrackingRange(10));
    public static final Id<PackPredator> HYENA = TFCEntities.register("hyena", EntityType.Builder.of(PackPredator::createHyena, (MobCategory)MobCategory.CREATURE).sized(0.65f, 0.9f).clientTrackingRange(10));
    public static final Id<PackPredator> DIREWOLF = TFCEntities.register("direwolf", EntityType.Builder.of(PackPredator::createDirewolf, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.2f).clientTrackingRange(10));
    public static final Id<Mammal> PIG = TFCEntities.register("pig", EntityType.Builder.of(TFCEntities::makePig, (MobCategory)MobCategory.CREATURE).sized(0.9f, 0.9f).clientTrackingRange(10));
    public static final Id<DairyAnimal> COW = TFCEntities.register("cow", EntityType.Builder.of(TFCEntities::makeCow, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.4f).eyeHeight(1.3f).clientTrackingRange(10));
    public static final Id<DairyAnimal> GOAT = TFCEntities.register("goat", EntityType.Builder.of(TFCEntities::makeGoat, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.3f).clientTrackingRange(10));
    public static final Id<DairyAnimal> YAK = TFCEntities.register("yak", EntityType.Builder.of(TFCEntities::makeYak, (MobCategory)MobCategory.CREATURE).sized(1.3f, 1.7f).clientTrackingRange(10));
    public static final Id<WoolyAnimal> ALPACA = TFCEntities.register("alpaca", EntityType.Builder.of(TFCEntities::makeAlpaca, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.9f).clientTrackingRange(10));
    public static final Id<WoolyAnimal> SHEEP = TFCEntities.register("sheep", EntityType.Builder.of(TFCEntities::makeSheep, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.2f).clientTrackingRange(10));
    public static final Id<WoolyAnimal> MUSK_OX = TFCEntities.register("musk_ox", EntityType.Builder.of(TFCEntities::makeMuskOx, (MobCategory)MobCategory.CREATURE).sized(1.3f, 1.5f).clientTrackingRange(10));
    public static final Id<OviparousAnimal> CHICKEN = TFCEntities.register("chicken", EntityType.Builder.of(TFCEntities::makeChicken, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.7f).eyeHeight(0.644f).clientTrackingRange(10));
    public static final Id<OviparousAnimal> DUCK = TFCEntities.register("duck", EntityType.Builder.of(TFCEntities::makeDuck, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.7f).eyeHeight(0.644f).clientTrackingRange(10));
    public static final Id<OviparousAnimal> QUAIL = TFCEntities.register("quail", EntityType.Builder.of(TFCEntities::makeQuail, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.7f).eyeHeight(0.644f).clientTrackingRange(10));
    public static final Id<TFCRabbit> RABBIT = TFCEntities.register("rabbit", EntityType.Builder.of(TFCEntities::makeRabbit, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.5f).clientTrackingRange(8));
    public static final Id<TFCFox> FOX = TFCEntities.register("fox", EntityType.Builder.of(TFCFox::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.7f).eyeHeight(0.4f).clientTrackingRange(8));
    public static final Id<TFCPanda> PANDA = TFCEntities.register("panda", EntityType.Builder.of(TFCPanda::new, (MobCategory)MobCategory.CREATURE).sized(1.3f, 1.25f).clientTrackingRange(10));
    public static final Id<TFCOcelot> OCELOT = TFCEntities.register("ocelot", EntityType.Builder.of(TFCOcelot::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.7f).clientTrackingRange(10));
    public static final Id<Prey> DEER = TFCEntities.register("deer", EntityType.Builder.of(TFCEntities::makeDeer, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.3f).clientTrackingRange(10));
    public static final Id<Prey> CARIBOU = TFCEntities.register("caribou", EntityType.Builder.of(TFCEntities::makeCaribou, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.3f).clientTrackingRange(10));
    public static final Id<Prey> BONGO = TFCEntities.register("bongo", EntityType.Builder.of(TFCEntities::makeBongo, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.3f).clientTrackingRange(10));
    public static final Id<Prey> GAZELLE = TFCEntities.register("gazelle", EntityType.Builder.of(TFCEntities::makeGazelle, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.3f).clientTrackingRange(10));
    public static final Id<WingedPrey> GROUSE = TFCEntities.register("grouse", EntityType.Builder.of(TFCEntities::makeGrouse, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.7f).clientTrackingRange(10));
    public static final Id<WingedPrey> PHEASANT = TFCEntities.register("pheasant", EntityType.Builder.of(TFCEntities::makePheasant, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.7f).eyeHeight(0.644f).clientTrackingRange(10));
    public static final Id<WingedPrey> TURKEY = TFCEntities.register("turkey", EntityType.Builder.of(TFCEntities::makeTurkey, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.8f).eyeHeight(0.644f).clientTrackingRange(10));
    public static final Id<WingedPrey> PEAFOWL = TFCEntities.register("peafowl", EntityType.Builder.of(TFCEntities::makePeafowl, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.8f).eyeHeight(0.644f).clientTrackingRange(10));
    public static final Id<RammingPrey> BOAR = TFCEntities.register("boar", EntityType.Builder.of(TFCEntities::makeBoar, (MobCategory)MobCategory.CREATURE).sized(0.9f, 0.9f).clientTrackingRange(10));
    public static final Id<RammingPrey> MOOSE = TFCEntities.register("moose", EntityType.Builder.of(TFCEntities::makeMoose, (MobCategory)MobCategory.CREATURE).sized(1.8f, 2.2f).clientTrackingRange(10));
    public static final Id<RammingPrey> WILDEBEEST = TFCEntities.register("wildebeest", EntityType.Builder.of(TFCEntities::makeWildebeest, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.4f).clientTrackingRange(10));
    public static final Id<RammingPrey> BISON = TFCEntities.register("bison", EntityType.Builder.of(TFCEntities::makeBison, (MobCategory)MobCategory.CREATURE).sized(1.5f, 2.0f).clientTrackingRange(10));
    public static final Id<Pest> RAT = TFCEntities.register("rat", EntityType.Builder.of(TFCEntities::makeRat, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.3f).eyeHeight(0.13f).clientTrackingRange(8));
    public static final Id<Pest> LEMMING = TFCEntities.register("lemming", EntityType.Builder.of(TFCEntities::makeRat, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.3f).eyeHeight(0.13f).clientTrackingRange(8));
    public static final Id<Pest> MONGOOSE = TFCEntities.register("mongoose", EntityType.Builder.of(TFCEntities::makeRat, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.4f).eyeHeight(0.23f).clientTrackingRange(8));
    public static final Id<Pest> JERBOA = TFCEntities.register("jerboa", EntityType.Builder.of(TFCEntities::makeRat, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.4f).eyeHeight(0.23f).clientTrackingRange(8));
    public static final Id<TFCDonkey> DONKEY = TFCEntities.register("donkey", EntityType.Builder.of(TFCDonkey::new, (MobCategory)MobCategory.CREATURE).sized(1.3964844f, 1.5f).eyeHeight(1.425f).passengerAttachments(new float[]{1.1125f}).clientTrackingRange(10));
    public static final Id<TFCMule> MULE = TFCEntities.register("mule", EntityType.Builder.of(TFCMule::new, (MobCategory)MobCategory.CREATURE).sized(1.3964844f, 1.6f).eyeHeight(1.52f).passengerAttachments(new float[]{1.2125f}).clientTrackingRange(8));
    public static final Id<TFCHorse> HORSE = TFCEntities.register("horse", EntityType.Builder.of(TFCHorse::new, (MobCategory)MobCategory.CREATURE).sized(1.3964844f, 1.6f).eyeHeight(1.52f).passengerAttachments(new float[]{1.44375f}).clientTrackingRange(10));
    public static final Id<TFCCat> CAT = TFCEntities.register("cat", EntityType.Builder.of(TFCCat::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.7f).eyeHeight(0.35f).clientTrackingRange(8));
    public static final Id<Dog> DOG = TFCEntities.register("dog", EntityType.Builder.of(Dog::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.85f).eyeHeight(0.68f).clientTrackingRange(10));

    public static <E extends Entity> Id<E> register(String name, EntityType.Builder<E> builder) {
        return TFCEntities.register(name, builder, true);
    }

    public static <E extends Entity> Id<E> register(String name, EntityType.Builder<E> builder, boolean serialize) {
        String id = name.toLowerCase(Locale.ROOT);
        return new Id(ENTITIES.register(id, () -> {
            if (!serialize) {
                builder.noSave();
            }
            return builder.build("tfc:" + id);
        }));
    }

    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        FRESHWATER_FISH.values().forEach(reg -> event.put((EntityType)reg.get(), AbstractFish.createAttributes().build()));
        event.put((EntityType)COD.get(), AbstractFish.createAttributes().build());
        event.put((EntityType)TROPICAL_FISH.get(), AbstractFish.createAttributes().build());
        event.put((EntityType)PUFFERFISH.get(), AbstractFish.createAttributes().build());
        event.put((EntityType)JELLYFISH.get(), AbstractFish.createAttributes().build());
        event.put((EntityType)LOBSTER.get(), AbstractFish.createAttributes().build());
        event.put((EntityType)CRAYFISH.get(), AbstractFish.createAttributes().build());
        event.put((EntityType)ISOPOD.get(), AbstractFish.createAttributes().build());
        event.put((EntityType)HORSESHOE_CRAB.get(), AbstractFish.createAttributes().build());
        event.put((EntityType)DOLPHIN.get(), Dolphin.createAttributes().build());
        event.put((EntityType)ORCA.get(), Dolphin.createAttributes().build());
        event.put((EntityType)MANATEE.get(), Manatee.createAttributes().build());
        event.put((EntityType)TURTLE.get(), AmphibiousAnimal.createAttributes().build());
        event.put((EntityType)PENGUIN.get(), Penguin.createAttributes().build());
        event.put((EntityType)LEOPARD_SEAL.get(), LeopardSeal.createAttributes().build());
        event.put((EntityType)FROG.get(), TFCFrog.createAttributes().build());
        event.put((EntityType)POLAR_BEAR.get(), Predator.createBearAttributes().build());
        event.put((EntityType)GRIZZLY_BEAR.get(), Predator.createBearAttributes().build());
        event.put((EntityType)BLACK_BEAR.get(), Predator.createBearAttributes().build());
        event.put((EntityType)COUGAR.get(), FelinePredator.createAttributes().build());
        event.put((EntityType)PANTHER.get(), FelinePredator.createAttributes().build());
        event.put((EntityType)LION.get(), FelinePredator.createAttributes().build());
        event.put((EntityType)SABERTOOTH.get(), FelinePredator.createAttributes().build());
        event.put((EntityType)TIGER.get(), FelinePredator.createAttributes().build());
        event.put((EntityType)CROCODILE.get(), AmphibiousPredator.createAttributes().build());
        event.put((EntityType)WOLF.get(), Predator.createAttributes().build());
        event.put((EntityType)HYENA.get(), Predator.createAttributes().build());
        event.put((EntityType)DIREWOLF.get(), Predator.createAttributes().build());
        event.put((EntityType)SQUID.get(), Squid.createAttributes().build());
        event.put((EntityType)OCTOPOTEUTHIS.get(), GlowSquid.createAttributes().build());
        event.put((EntityType)PIG.get(), Pig.createAttributes().add(Attributes.STEP_HEIGHT, 1.0).build());
        event.put((EntityType)COW.get(), Cow.createAttributes().add(Attributes.STEP_HEIGHT, 1.0).build());
        event.put((EntityType)GOAT.get(), Pig.createAttributes().add(Attributes.STEP_HEIGHT, 1.0).build());
        event.put((EntityType)YAK.get(), Cow.createAttributes().add(Attributes.STEP_HEIGHT, 1.0).build());
        event.put((EntityType)ALPACA.get(), Cow.createAttributes().add(Attributes.STEP_HEIGHT, 1.0).build());
        event.put((EntityType)SHEEP.get(), Cow.createAttributes().add(Attributes.STEP_HEIGHT, 1.0).build());
        event.put((EntityType)MUSK_OX.get(), Cow.createAttributes().add(Attributes.STEP_HEIGHT, 1.0).build());
        event.put((EntityType)CHICKEN.get(), OviparousAnimal.createAttributes().build());
        event.put((EntityType)DUCK.get(), OviparousAnimal.createAttributes().build());
        event.put((EntityType)QUAIL.get(), OviparousAnimal.createAttributes().build());
        event.put((EntityType)RABBIT.get(), TFCRabbit.createAttributes().build());
        event.put((EntityType)FOX.get(), TFCFox.createAttributes().build());
        event.put((EntityType)DEER.get(), Prey.createAttributes().build());
        event.put((EntityType)BONGO.get(), Prey.createAttributes().build());
        event.put((EntityType)GAZELLE.get(), Prey.createAttributes().build());
        event.put((EntityType)CARIBOU.get(), Prey.createAttributes().build());
        event.put((EntityType)BOAR.get(), RammingPrey.createAttributes().build());
        event.put((EntityType)WILDEBEEST.get(), RammingPrey.createMediumAttributes().build());
        event.put((EntityType)MOOSE.get(), RammingPrey.createLargeAttributes().build());
        event.put((EntityType)BISON.get(), RammingPrey.createLargeAttributes().build());
        event.put((EntityType)GROUSE.get(), OviparousAnimal.createAttributes().build());
        event.put((EntityType)PHEASANT.get(), OviparousAnimal.createAttributes().build());
        event.put((EntityType)TURKEY.get(), OviparousAnimal.createAttributes().build());
        event.put((EntityType)PEAFOWL.get(), OviparousAnimal.createAttributes().build());
        event.put((EntityType)RAT.get(), Pest.createAttributes().build());
        event.put((EntityType)LEMMING.get(), Pest.createAttributes().build());
        event.put((EntityType)MONGOOSE.get(), Pest.createAttributes().build());
        event.put((EntityType)JERBOA.get(), Pest.createAttributes().build());
        event.put((EntityType)MULE.get(), AbstractChestedHorse.createBaseChestedHorseAttributes().build());
        event.put((EntityType)DONKEY.get(), AbstractChestedHorse.createBaseChestedHorseAttributes().build());
        event.put((EntityType)HORSE.get(), AbstractHorse.createBaseHorseAttributes().build());
        event.put((EntityType)CAT.get(), TFCCat.createAttributes().build());
        event.put((EntityType)DOG.get(), Dog.createAttributes().build());
        event.put((EntityType)PANDA.get(), TFCPanda.createAttributes().add(Attributes.STEP_HEIGHT, 1.0).build());
        event.put((EntityType)OCELOT.get(), TFCOcelot.createAttributes().build());
    }

    public static Mammal makePig(EntityType<? extends Mammal> animal, Level level) {
        return new Mammal((EntityType)animal, level, TFCSounds.PIG, TFCConfig.SERVER.pigConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.PIG_FOOD;
            }
        };
    }

    public static DairyAnimal makeCow(EntityType<? extends DairyAnimal> animal, Level level) {
        return new DairyAnimal((EntityType)animal, level, TFCSounds.COW, TFCConfig.SERVER.cowConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.COW_FOOD;
            }
        };
    }

    public static DairyAnimal makeGoat(EntityType<? extends DairyAnimal> animal, Level level) {
        return new DairyAnimal((EntityType)animal, level, TFCSounds.GOAT, TFCConfig.SERVER.goatConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.GOAT_FOOD;
            }
        };
    }

    public static DairyAnimal makeYak(EntityType<? extends DairyAnimal> animal, Level level) {
        return new DairyAnimal((EntityType)animal, level, TFCSounds.YAK, TFCConfig.SERVER.yakConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.YAK_FOOD;
            }
        };
    }

    public static WoolyAnimal makeAlpaca(EntityType<? extends WoolyAnimal> animal, Level level) {
        return new WoolyAnimal((EntityType)animal, level, TFCSounds.ALPACA, TFCConfig.SERVER.alpacaConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.ALPACA_FOOD;
            }
        };
    }

    public static WoolyAnimal makeSheep(EntityType<? extends WoolyAnimal> animal, Level level) {
        return new WoolyAnimal((EntityType)animal, level, TFCSounds.SHEEP, TFCConfig.SERVER.sheepConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.SHEEP_FOOD;
            }
        };
    }

    public static WoolyAnimal makeMuskOx(EntityType<? extends WoolyAnimal> animal, Level level) {
        return new WoolyAnimal((EntityType)animal, level, TFCSounds.MUSK_OX, TFCConfig.SERVER.muskOxConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.MUSK_OX_FOOD;
            }
        };
    }

    public static OviparousAnimal makeChicken(EntityType<? extends OviparousAnimal> animal, Level level) {
        return new OviparousAnimal((EntityType)animal, level, TFCSounds.CHICKEN, TFCConfig.SERVER.chickenConfig, true){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.CHICKEN_FOOD;
            }
        };
    }

    public static OviparousAnimal makeDuck(EntityType<? extends OviparousAnimal> animal, Level level) {
        return new OviparousAnimal((EntityType)animal, level, TFCSounds.DUCK, TFCConfig.SERVER.duckConfig, false){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.DUCK_FOOD;
            }
        };
    }

    public static OviparousAnimal makeQuail(EntityType<? extends OviparousAnimal> animal, Level level) {
        return new OviparousAnimal((EntityType)animal, level, TFCSounds.QUAIL, TFCConfig.SERVER.quailConfig, false){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.QUAIL_FOOD;
            }
        };
    }

    public static TFCRabbit makeRabbit(EntityType<? extends Rabbit> animal, Level level) {
        return new TFCRabbit(animal, level, TFCConfig.SERVER.rabbitConfig);
    }

    public static RammingPrey makeBoar(EntityType<? extends RammingPrey> animal, Level level) {
        return new RammingPrey(animal, level, TFCSounds.BOAR, 0.1);
    }

    public static RammingPrey makeWildebeest(EntityType<? extends RammingPrey> animal, Level level) {
        return new RammingPrey(animal, level, TFCSounds.WILDEBEEST, 0.1);
    }

    public static RammingPrey makeMoose(EntityType<? extends RammingPrey> animal, Level level) {
        return new RammingPrey(animal, level, TFCSounds.MOOSE, 0.75);
    }

    public static RammingPrey makeBison(EntityType<? extends RammingPrey> animal, Level level) {
        return new RammingPrey(animal, level, TFCSounds.BISON, 0.75);
    }

    public static Prey makeBongo(EntityType<? extends Prey> animal, Level level) {
        return new Prey((EntityType<? extends WildAnimal>)animal, level, TFCSounds.BONGO);
    }

    public static Prey makeCaribou(EntityType<? extends Prey> animal, Level level) {
        return new Prey((EntityType<? extends WildAnimal>)animal, level, TFCSounds.CARIBOU);
    }

    public static Prey makeDeer(EntityType<? extends Prey> animal, Level level) {
        return new Prey((EntityType<? extends WildAnimal>)animal, level, TFCSounds.DEER);
    }

    public static Prey makeGazelle(EntityType<? extends Prey> animal, Level level) {
        return new Prey((EntityType<? extends WildAnimal>)animal, level, TFCSounds.GAZELLE);
    }

    public static WingedPrey makePheasant(EntityType<? extends WingedPrey> animal, Level level) {
        return new WingedPrey((EntityType<? extends Prey>)animal, level, TFCSounds.PHEASANT);
    }

    public static WingedPrey makeGrouse(EntityType<? extends WingedPrey> animal, Level level) {
        return new WingedPrey((EntityType<? extends Prey>)animal, level, TFCSounds.GROUSE);
    }

    public static WingedPrey makeTurkey(EntityType<? extends WingedPrey> animal, Level level) {
        return new WingedPrey((EntityType<? extends Prey>)animal, level, TFCSounds.TURKEY);
    }

    public static WingedPrey makePeafowl(EntityType<? extends WingedPrey> animal, Level level) {
        return new WingedPrey((EntityType<? extends Prey>)animal, level, TFCSounds.PEAFOWL);
    }

    public static Pest makeRat(EntityType<? extends Pest> animal, Level level) {
        return new Pest((EntityType<? extends Prey>)animal, level, TFCSounds.RAT);
    }

    public record Id<T extends Entity>(DeferredHolder<EntityType<?>, EntityType<T>> holder) implements RegistryHolder<EntityType<?>, EntityType<T>>
    {
    }
}

