/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai;

import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.component.BaitType;
import net.dries007.tfc.common.entities.misc.TFCFishingHook;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class GetHookedGoal
extends MoveToBlockGoal {
    @Nullable
    private TFCFishingHook hook = null;

    public GetHookedGoal(PathfinderMob mob) {
        super(mob, 0.9, 16);
    }

    public void tick() {
        if (this.isReachedTarget() && this.hook != null) {
            this.hook.setHookedEntity((Entity)this.mob);
            this.mob.level().playSound(null, this.mob.blockPosition(), SoundEvents.FISHING_BOBBER_SPLASH, SoundSource.NEUTRAL, 1.0f + this.mob.getRandom().nextFloat(), this.mob.getRandom().nextFloat() + 0.7f + 0.3f);
            if (Helpers.isEntity((Entity)this.mob, TFCTags.Entities.NEEDS_LARGE_FISHING_BAIT) || this.mob.getRandom().nextInt(12) == 0) {
                this.hook.eatBait();
            }
        }
        super.tick();
    }

    public boolean canContinueToUse() {
        return this.hook != null && !this.hook.isRemoved() && this.hook.getPlayerOwner() != null && this.hook.getHookedIn() == null && super.canContinueToUse();
    }

    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        return Helpers.isFluid(level.getFluidState(pos), TFCTags.Fluids.ANY_INFINITE_WATER);
    }

    protected BlockPos getMoveToTarget() {
        return this.blockPos;
    }

    protected boolean findNearestBlock() {
        List entities = this.mob.level().getEntitiesOfClass(TFCFishingHook.class, new AABB(this.mob.blockPosition()).inflate(12.0), hook -> !hook.isRemoved());
        if (!entities.isEmpty()) {
            TFCFishingHook possibleHook = (TFCFishingHook)((Object)entities.get(0));
            ItemStack bait = possibleHook.getBait();
            BaitType type = BaitType.getType(bait);
            boolean isLarge = Helpers.isEntity((Entity)this.mob, TFCTags.Entities.NEEDS_LARGE_FISHING_BAIT);
            if (type == BaitType.LARGE && isLarge || type == BaitType.SMALL && !isLarge) {
                this.hook = possibleHook;
                this.blockPos = this.hook.blockPosition();
                return true;
            }
        }
        return false;
    }
}

