/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai;

import java.util.EnumSet;
import net.dries007.tfc.common.entities.misc.ThrownJavelin;
import net.dries007.tfc.common.items.JavelinItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;

public class JavelinAttackGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public JavelinAttackGoal(T mob, double speed, float attackRadius) {
        this.mob = mob;
        this.speedModifier = speed;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.mob.getTarget() != null && this.isHoldingJavelin();
    }

    protected boolean isHoldingJavelin() {
        return this.mob.isHolding(is -> is.getItem() instanceof JavelinItem);
    }

    public boolean canContinueToUse() {
        return (this.canUse() || !this.mob.getNavigation().isDone()) && this.isHoldingJavelin();
    }

    public void start() {
        super.start();
        this.mob.setAggressive(true);
    }

    public void stop() {
        super.stop();
        this.mob.setAggressive(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.stopUsingItem();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity != null) {
            boolean hasSeen;
            double distSquared = this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
            boolean seeing = this.mob.getSensing().hasLineOfSight((Entity)livingentity);
            boolean bl = hasSeen = this.seeTime > 0;
            if (seeing != hasSeen) {
                this.seeTime = 0;
            }
            this.seeTime += seeing ? 1 : -1;
            if (!(distSquared > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                this.mob.getNavigation().stop();
                ++this.strafingTime;
            } else {
                this.mob.getNavigation().moveTo((Entity)livingentity, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distSquared > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (distSquared < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.mob.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.mob.lookAt((Entity)livingentity, 30.0f, 30.0f);
            } else {
                this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            }
            if (this.mob.isUsingItem()) {
                if (!seeing && this.seeTime < -60) {
                    this.mob.stopUsingItem();
                } else if (seeing && this.mob.getTicksUsingItem() >= 20) {
                    this.mob.stopUsingItem();
                    this.performRangedAttack(livingentity);
                    this.attackTime = this.mob.level().getDifficulty() == Difficulty.HARD ? 20 : 40;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.mob.startUsingItem(this.getHand());
            }
        }
    }

    public void performRangedAttack(LivingEntity target) {
        ItemStack itemstack = this.getWeaponInHand();
        ThrownJavelin javelin = new ThrownJavelin(this.mob.level(), (LivingEntity)this.mob, itemstack);
        double dx = target.getX() - this.mob.getX();
        double dy = target.getY(0.3333333333333333) - javelin.getY();
        double dz = target.getZ() - this.mob.getZ();
        double dist = Math.sqrt(dx * dx + dz * dz);
        javelin.shoot(dx, dy + dist * (double)0.2f, dz, 1.6f, 14 - this.mob.level().getDifficulty().getId() * 4);
        this.mob.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.mob.getRandom().nextFloat() * 0.4f + 0.8f));
        this.mob.level().addFreshEntity((Entity)javelin);
    }

    public ItemStack getWeaponInHand() {
        return this.mob.getItemInHand(this.getHand());
    }

    public InteractionHand getHand() {
        return ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof JavelinItem);
    }
}

