/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai;

import net.dries007.tfc.common.entities.misc.TFCFishingHook;
import net.dries007.tfc.util.Helpers;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class TFCAvoidEntityGoal<T extends LivingEntity>
extends AvoidEntityGoal<T> {
    private final TargetingConditions avoidEntityTargeting;

    public TFCAvoidEntityGoal(PathfinderMob mob, Class<T> avoidClass, float dist, double farSpeed, double nearSpeed, TagKey<EntityType<?>> tag) {
        super(mob, avoidClass, dist, farSpeed, nearSpeed);
        this.avoidEntityTargeting = TargetingConditions.forCombat().range((double)dist).selector(e -> Helpers.isEntity((Entity)e, tag));
    }

    public TFCAvoidEntityGoal(PathfinderMob mob, Class<T> avoidClass, float dist, double farSpeed, double nearSpeed) {
        super(mob, avoidClass, dist, farSpeed, nearSpeed);
        this.avoidEntityTargeting = TargetingConditions.forCombat().range((double)dist).selector(EntitySelector.NO_SPECTATORS::test);
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && !this.isHooked();
    }

    public boolean canUse() {
        this.toAvoid = this.mob.level().getNearestEntity(this.mob.level().getEntitiesOfClass(this.avoidClass, this.mob.getBoundingBox().inflate((double)this.maxDist, 3.0, (double)this.maxDist), p_148078_ -> true), this.avoidEntityTargeting, (LivingEntity)this.mob, this.mob.getX(), this.mob.getY(), this.mob.getZ());
        if (this.toAvoid == null) {
            return false;
        }
        if ((this.toAvoid.isSteppingCarefully() || this.toAvoid.getDeltaMovement().length() < 0.01) && !this.toAvoid.isInWater()) {
            return false;
        }
        if (this.isHooked()) {
            return false;
        }
        Vec3 vec3 = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.toAvoid.position());
        if (vec3 == null) {
            return false;
        }
        if (this.toAvoid.distanceToSqr(vec3.x, vec3.y, vec3.z) < this.toAvoid.distanceToSqr((Entity)this.mob)) {
            return false;
        }
        this.path = this.pathNav.createPath(vec3.x, vec3.y, vec3.z, 0);
        return this.path != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isHooked() {
        if (this.toAvoid == null) return false;
        LivingEntity livingEntity = this.toAvoid;
        if (!(livingEntity instanceof Player)) return false;
        Player player = (Player)livingEntity;
        livingEntity = player.fishing;
        if (!(livingEntity instanceof TFCFishingHook)) return false;
        TFCFishingHook hook = (TFCFishingHook)livingEntity;
        if (hook.getHookedIn() != this.mob) return false;
        return true;
    }
}

