/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class TFCFishMoveControl
extends MoveControl {
    private final PathfinderMob fish;

    public TFCFishMoveControl(PathfinderMob fish) {
        super((Mob)fish);
        this.fish = fish;
    }

    public void tick() {
        if (this.fish.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value())) {
            this.fish.setDeltaMovement(this.fish.getDeltaMovement().add(0.0, 0.005, 0.0));
        }
        if (this.operation == MoveControl.Operation.MOVE_TO && !this.fish.getNavigation().isDone()) {
            float fishSpeed = (float)(this.speedModifier * this.fish.getAttributeValue(Attributes.MOVEMENT_SPEED));
            this.fish.setSpeed(Mth.lerp((float)0.125f, (float)this.fish.getSpeed(), (float)fishSpeed));
            double dx = this.wantedX - this.fish.getX();
            double dy = this.wantedY - this.fish.getY();
            double dz = this.wantedZ - this.fish.getZ();
            if (dy != 0.0) {
                double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
                this.fish.setDeltaMovement(this.fish.getDeltaMovement().add((double)this.fish.getSpeed() * (dx / length) * 0.03, (double)this.fish.getSpeed() * (dy / length) * 0.1, (double)this.fish.getSpeed() * (dz / length) * 0.1));
            }
            if (dx != 0.0 || dz != 0.0) {
                float f1 = (float)(Mth.atan2((double)dz, (double)dx) * 57.2957763671875) - 90.0f;
                this.fish.setYRot(this.rotlerp(this.fish.getYRot(), f1, 90.0f));
                this.fish.yBodyRot = this.fish.getYRot();
            }
        } else {
            this.fish.setSpeed(0.0f);
        }
    }
}

