/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TFCGroundPathNavigation
extends GroundPathNavigation {
    public static int getSurfaceYRespectingFluid(GroundPathNavigation navigation, Mob mob, Level level) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        if (mob.isInWater() && navigation.canFloat()) {
            BlockState state = level.getBlockState((BlockPos)cursor.set(mob.getX(), (double)mob.getBlockY(), mob.getZ()));
            int checked = 0;
            while (Helpers.isFluid(state.getFluidState(), TFCTags.Fluids.ANY_INFINITE_WATER)) {
                state = level.getBlockState((BlockPos)cursor.move(0, 1, 0));
                if (++checked <= 16) continue;
                return mob.getBlockY();
            }
            return cursor.getY();
        }
        return Mth.floor((double)(mob.getY() + 0.5));
    }

    public TFCGroundPathNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    protected PathFinder createPathFinder(int followRange) {
        this.nodeEvaluator = new TFCWalkNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        return new PathFinder(this.nodeEvaluator, followRange);
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), (double)TFCGroundPathNavigation.getSurfaceYRespectingFluid(this, this.mob, this.level), this.mob.getZ());
    }

    public static class TFCWalkNodeEvaluator
    extends WalkNodeEvaluator {
        public PathType getPathType(PathfindingContext context, int x, int y, int z) {
            PathType pathType = super.getPathType(context, x, y, z);
            return pathType == PathType.LEAVES ? PathType.OPEN : pathType;
        }

        public Node getStart() {
            int yPos;
            BlockPos.MutableBlockPos cursor;
            block11: {
                cursor = new BlockPos.MutableBlockPos();
                yPos = this.mob.getBlockY();
                BlockState groundState = this.currentContext.getBlockState((BlockPos)cursor.set(this.mob.getX(), (double)yPos, this.mob.getZ()));
                if (!this.mob.canStandOnFluid(groundState.getFluidState())) {
                    if (this.canFloat() && this.mob.isInWater()) {
                        while (true) {
                            if (!Helpers.isFluid(groundState.getFluidState(), TFCTags.Fluids.ANY_INFINITE_WATER)) {
                                --yPos;
                                break block11;
                            }
                            groundState = this.currentContext.getBlockState((BlockPos)cursor.set(this.mob.getX(), (double)(++yPos), this.mob.getZ()));
                        }
                    }
                    if (this.mob.onGround()) {
                        yPos = Mth.floor((double)(this.mob.getY() + 0.5));
                    } else {
                        cursor.set(this.mob.getX(), this.mob.getY() + 1.0, this.mob.getZ());
                        while (cursor.getY() > this.currentContext.level().getMinBuildHeight()) {
                            yPos = cursor.getY();
                            cursor.setY(cursor.getY() - 1);
                            BlockState insideState = this.currentContext.getBlockState((BlockPos)cursor);
                            if (insideState.isAir() || insideState.isPathfindable(PathComputationType.LAND)) continue;
                            break;
                        }
                    }
                } else {
                    while (this.mob.canStandOnFluid(groundState.getFluidState())) {
                        groundState = this.currentContext.getBlockState((BlockPos)cursor.set(this.mob.getX(), (double)(++yPos), this.mob.getZ()));
                    }
                    --yPos;
                }
            }
            BlockPos mobPos = this.mob.blockPosition();
            if (!this.canStartAt((BlockPos)cursor.set(mobPos.getX(), yPos, mobPos.getZ()))) {
                AABB box = this.mob.getBoundingBox();
                if (this.canStartAt((BlockPos)cursor.set(box.minX, (double)yPos, box.minZ)) || this.canStartAt((BlockPos)cursor.set(box.minX, (double)yPos, box.maxZ)) || this.canStartAt((BlockPos)cursor.set(box.maxX, (double)yPos, box.minZ)) || this.canStartAt((BlockPos)cursor.set(box.maxX, (double)yPos, box.maxZ))) {
                    return this.getStartNode((BlockPos)cursor);
                }
            }
            return this.getStartNode((BlockPos)cursor);
        }
    }
}

