/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.amphibian;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.amphibian.AmphibianPlayDeadBehavior;
import net.dries007.tfc.common.entities.ai.amphibian.AmphibiousStrollToPoi;
import net.dries007.tfc.common.entities.aquatic.AmphibiousAnimal;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.TryFindWater;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class AmphibianAi {
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)15, (int)30);
    public static final ImmutableList<SensorType<? extends Sensor<? super AmphibiousAnimal>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_ADULT, (Object)SensorType.HURT_BY, (Object)((SensorType)TFCBrain.TEMPTATION_SENSOR.get()));
    public static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.HUNTED_RECENTLY, (Object)MemoryModuleType.PLAY_DEAD_TICKS, (Object[])new MemoryModuleType[]{MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.HOME, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.IS_TEMPTED, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.BREED_TARGET, MemoryModuleType.IS_PANICKING});

    public static Brain<?> makeBrain(Brain<? extends AmphibiousAnimal> brain) {
        AmphibianAi.initCoreActivity(brain);
        AmphibianAi.initIdleActivity(brain);
        AmphibianAi.initPlayDeadActivity(brain);
        AmphibianAi.initFightActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<? extends AmphibiousAnimal> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<? extends AmphibiousAnimal> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, SetLookTarget.create(TFCTags.Entities.TURTLE_FRIENDS, 6.0f, UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)BabyFollowAdult.create((UniformInt)ADULT_FOLLOW_RANGE, AmphibianAi::getChasingSpeedModifier), (Object)1), (Object)Pair.of((Object)new FollowTemptation(AmphibianAi::getSpeedModifier), (Object)1)))), (Object)Pair.of((Object)3, (Object)TryFindWater.create((int)6, (float)0.15f)), (Object)Pair.of((Object)4, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)StartAttacking.create(AmphibianAi::getAttackTarget), (Object)2), (Object)Pair.of((Object)RandomStroll.swim((float)0.5f), (Object)2), (Object)Pair.of((Object)RandomStroll.stroll((float)0.15f, (boolean)false), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create(AmphibianAi::canSetWalkTargetFromLookTarget, AmphibianAi::getSpeedModifier, (int)3), (Object)3), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)3), (Object)Pair.of(AmphibiousStrollToPoi.create((MemoryModuleType<GlobalPos>)MemoryModuleType.HOME, AmphibianAi::getSpeedModifier, 5, 100), (Object)3))))));
    }

    private static void initPlayDeadActivity(Brain<? extends AmphibiousAnimal> brain) {
        brain.addActivityAndRemoveMemoriesWhenStopped(Activity.PLAY_DEAD, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new AmphibianPlayDeadBehavior()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.PLAY_DEAD_TICKS, (Object)MemoryStatus.VALUE_PRESENT)), (Set)ImmutableSet.of((Object)MemoryModuleType.PLAY_DEAD_TICKS));
    }

    private static void initFightActivity(Brain<? extends AmphibiousAnimal> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 0, ImmutableList.of((Object)StopAttackingIfTargetInvalid.create(), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create(AmphibianAi::getChasingSpeedModifier), (Object)MeleeAttack.create((int)20), (Object)EraseMemoryIf.create(AmphibianAi::isTempted, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    public static void updateActivity(AmphibiousAnimal animal) {
        Brain<AmphibiousAnimal> brain = animal.getBrain();
        Activity current = brain.getActiveNonCoreActivity().orElse(null);
        AmphibianPlayDeadBehavior.update(animal);
        if (current != Activity.PLAY_DEAD) {
            brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.PLAY_DEAD, (Object)Activity.FIGHT, (Object)Activity.IDLE));
        }
    }

    private static boolean isTempted(AmphibiousAnimal entity) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER);
    }

    private static Optional<? extends LivingEntity> getAttackTarget(AmphibiousAnimal entity) {
        if (entity.getBrain().hasMemoryValue(MemoryModuleType.HUNTED_RECENTLY)) {
            return Optional.empty();
        }
        return entity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(nearest -> nearest.findClosest(p -> Helpers.isEntity((Entity)p, TFCTags.Entities.SMALL_FISH) && p.isAlive()));
    }

    private static boolean canSetWalkTargetFromLookTarget(LivingEntity entity) {
        Level level = entity.level();
        Optional tracker = entity.getBrain().getMemory(MemoryModuleType.LOOK_TARGET);
        if (tracker.isPresent()) {
            BlockPos pos = ((PositionTracker)tracker.get()).currentBlockPosition();
            return EnvironmentHelpers.isWaterAt((LevelAccessor)level, pos) == entity.isInWaterOrBubble();
        }
        return false;
    }

    private static float getSpeedModifier(LivingEntity entity) {
        return entity.isInWaterOrBubble() ? 0.5f : 0.15f;
    }

    private static float getChasingSpeedModifier(LivingEntity entity) {
        return entity.isInWaterOrBubble() ? 0.6f : 0.17f;
    }
}

