/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.livestock;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.dries007.tfc.common.entities.Temptable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DelegatingTemptingSensor
extends Sensor<PathfinderMob> {
    public static final int TEMPTATION_RANGE = 10;
    private static final TargetingConditions TEMPT_TARGETING = TargetingConditions.forNonCombat().range(10.0).ignoreLineOfSight();

    protected void doTick(ServerLevel level, PathfinderMob animal) {
        Brain brain = animal.getBrain();
        List<ServerPlayer> list = level.players().stream().filter(EntitySelector.NO_SPECTATORS).filter(p -> TEMPT_TARGETING.test((LivingEntity)animal, (LivingEntity)p)).filter(p -> animal.closerThan((Entity)p, 10.0)).filter(p -> this.playerHoldingTemptation((Player)p, animal)).sorted(Comparator.comparingDouble(arg_0 -> ((PathfinderMob)animal).distanceToSqr(arg_0))).toList();
        if (!list.isEmpty()) {
            Player player = (Player)list.get(0);
            brain.setMemory(MemoryModuleType.TEMPTING_PLAYER, (Object)player);
        } else {
            brain.eraseMemory(MemoryModuleType.TEMPTING_PLAYER);
        }
    }

    private boolean playerHoldingTemptation(Player player, PathfinderMob animal) {
        return this.isTemptation(player.getMainHandItem(), animal) || this.isTemptation(player.getOffhandItem(), animal);
    }

    private boolean isTemptation(ItemStack stack, PathfinderMob animal) {
        Temptable temptable;
        return animal instanceof Temptable && (temptable = (Temptable)animal).isFood(stack);
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)MemoryModuleType.TEMPTING_PLAYER);
    }
}

