/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.livestock;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.livestock.BreedBehavior;
import net.dries007.tfc.common.entities.ai.livestock.LayEggBehavior;
import net.dries007.tfc.common.entities.ai.livestock.LivestockAi;
import net.dries007.tfc.common.entities.ai.prey.AvoidPredatorAndRammersBehavior;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.minecraft.Util;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class OviparousAi {
    public static final ImmutableList<SensorType<? extends Sensor<? super OviparousAnimal>>> SENSOR_TYPES = (ImmutableList)Util.make(() -> {
        ArrayList list = Lists.newArrayList(LivestockAi.SENSOR_TYPES);
        list.add((SensorType)TFCBrain.NEST_BOX_SENSOR.get());
        return ImmutableList.copyOf((Collection)list);
    });
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = (ImmutableList)Util.make(() -> {
        ArrayList list = Lists.newArrayList(LivestockAi.MEMORY_TYPES);
        list.add((MemoryModuleType)TFCBrain.NEST_BOX_MEMORY.get());
        return ImmutableList.copyOf((Collection)list);
    });

    public static Brain<?> makeBrain(Brain<? extends OviparousAnimal> brain) {
        OviparousAi.initCoreActivity(brain);
        OviparousAi.initIdleActivity(brain);
        OviparousAi.initRetreatActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void initCoreActivity(Brain<? extends OviparousAnimal> brain) {
        LivestockAi.initCoreActivity(brain);
    }

    public static void initIdleActivity(Brain<? extends OviparousAnimal> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, SetLookTarget.create(EntityType.PLAYER, 6.0f, UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)0, AvoidPredatorAndRammersBehavior.create(true)), (Object)Pair.of((Object)0, (Object)((Object)new LayEggBehavior())), (Object)Pair.of((Object)1, new BreedBehavior(1.0f)), (Object)Pair.of((Object)1, (Object)new AnimalPanic(2.0f)), (Object)Pair.of((Object)2, (Object)new FollowTemptation(e -> Float.valueOf(e.isBaby() ? 1.5f : 1.25f))), (Object)Pair.of((Object)3, (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)4, LivestockAi.createIdleMovementBehaviors())));
    }

    public static void initRetreatActivity(Brain<? extends OviparousAnimal> brain) {
        LivestockAi.initRetreatActivity(brain);
    }
}

