/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.pet;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.livestock.BreedBehavior;
import net.dries007.tfc.common.entities.ai.livestock.LivestockAi;
import net.dries007.tfc.common.entities.ai.pet.FollowOwnerBehavior;
import net.dries007.tfc.common.entities.ai.pet.MoveToTargetSinkIfNotSleeping;
import net.dries007.tfc.common.entities.ai.pet.TamableFindSleepPos;
import net.dries007.tfc.common.entities.ai.pet.TamableSleepBehavior;
import net.dries007.tfc.common.entities.ai.prey.PreyAi;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.pet.TamableMammal;
import net.dries007.tfc.common.entities.prey.Pest;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class TamableAi {
    public static final ImmutableList<SensorType<? extends Sensor<? super TamableMammal>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ITEMS, (Object)SensorType.NEAREST_ADULT, (Object)SensorType.HURT_BY, (Object)((SensorType)TFCBrain.TEMPTATION_SENSOR.get()));
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.LAST_SLEPT, (Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_TEMPTED, (Object)MemoryModuleType.AVOID_TARGET, (Object[])new MemoryModuleType[]{MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.HURT_BY, MemoryModuleType.HOME, (MemoryModuleType)TFCBrain.SLEEP_POS.get(), (MemoryModuleType)TFCBrain.SIT_TIME.get(), MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.IS_PANICKING});
    public static final int HOME_WANDER_DISTANCE = 36;
    public static final int HOME_LOST_DISTANCE = 120;

    public static Brain<?> makeBrain(Brain<? extends TamableMammal> brain) {
        TamableAi.initCoreActivity(brain);
        TamableAi.initIdleActivity(brain);
        TamableAi.initIdleAtHomeActivity(brain);
        TamableAi.initRestActivity(brain);
        TamableAi.initRetreatActivity(brain);
        TamableAi.initFollowActivity(brain);
        TamableAi.initHuntActivity(brain);
        TamableAi.initFightActivity(brain);
        TamableAi.initSitActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void initCoreActivity(Brain<? extends TamableMammal> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)((Object)new MoveToTargetSinkIfNotSleeping()), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    public static void initIdleActivity(Brain<? extends TamableMammal> brain) {
        LivestockAi.initIdleActivity(brain);
    }

    public static void initIdleAtHomeActivity(Brain<? extends TamableMammal> brain) {
        brain.addActivity((Activity)TFCBrain.IDLE_AT_HOME.get(), ImmutableList.of((Object)Pair.of((Object)0, SetLookTarget.create(EntityType.PLAYER, 6.0f, UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, new BreedBehavior(0.5f)), (Object)Pair.of((Object)1, (Object)new AnimalPanic(1.0f)), (Object)Pair.of((Object)2, (Object)new FollowTemptation(e -> Float.valueOf(e.isBaby() ? 1.5f : 1.25f))), (Object)Pair.of((Object)3, (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)3, (Object)StrollToPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)1.0f, (int)10, (int)26)), (Object)Pair.of((Object)3, (Object)StartAttacking.create(TamableAi::getUnwantedAttackTarget)), (Object)Pair.of((Object)4, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)StrollToPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)0.6f, (int)10, (int)26), (Object)1), (Object)Pair.of((Object)StrollAroundPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)0.6f, (int)36), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    public static void initRestActivity(Brain<? extends TamableMammal> brain) {
        brain.addActivity(Activity.REST, 10, ImmutableList.of((Object)StrollToPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)1.2f, (int)5, (int)36), TamableFindSleepPos.create(), (Object)((Object)new TamableSleepBehavior())));
    }

    public static void initRetreatActivity(Brain<? extends TamableMammal> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.3f, (int)15, (boolean)false), TamableAi.createIdleMovementBehaviors(), SetLookTarget.create(8.0f, UniformInt.of((int)30, (int)60)), (Object)EraseMemoryIf.create(PreyAi::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    public static void initHuntActivity(Brain<? extends TamableMammal> brain) {
        brain.addActivity((Activity)TFCBrain.HUNT.get(), ImmutableList.of((Object)Pair.of((Object)0, FollowOwnerBehavior.create()), (Object)Pair.of((Object)1, (Object)StartAttacking.create(TamableAi::getAttackTarget)), (Object)Pair.of((Object)4, SetLookTarget.create(EntityType.PLAYER, 6.0f, UniformInt.of((int)30, (int)60)))));
    }

    public static void initFightActivity(Brain<? extends TamableMammal> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.15f), (Object)MeleeAttack.create((int)40), (Object)StopAttackingIfTargetInvalid.create(TamableAi::couldFlee, (t, e) -> t.refreshCommandOnNextTick(), (boolean)false)), MemoryModuleType.ATTACK_TARGET);
    }

    public static void initFollowActivity(Brain<? extends TamableMammal> brain) {
        brain.addActivity((Activity)TFCBrain.FOLLOW.get(), ImmutableList.of((Object)Pair.of((Object)0, FollowOwnerBehavior.create()), (Object)Pair.of((Object)1, SetLookTarget.create(EntityType.PLAYER, 6.0f, UniformInt.of((int)30, (int)60)))));
    }

    public static void initSitActivity(Brain<? extends TamableMammal> brain) {
        brain.addActivity((Activity)TFCBrain.SIT.get(), 1, ImmutableList.of(SetLookTarget.create(8.0f, UniformInt.of((int)30, (int)60)), SetLookTarget.create(EntityType.PLAYER, 8.0f, UniformInt.of((int)30, (int)60)), (Object)new DoNothing(30, 60)));
    }

    public static GateBehavior<TFCAnimal> createIdleMovementBehaviors() {
        return LivestockAi.createIdleMovementBehaviors();
    }

    public static boolean isTooFarFromHome(TamableMammal entity) {
        return TamableAi.isFarFromHome(entity, 36);
    }

    public static boolean isExtremelyFarFromHome(TamableMammal entity) {
        return TamableAi.isFarFromHome(entity, 120);
    }

    public static boolean isFarFromHome(TamableMammal entity, int distance) {
        return entity.getBrain().getMemory(MemoryModuleType.HOME).map(globalPos -> globalPos.dimension() != entity.level().dimension() || globalPos.pos().distSqr((Vec3i)entity.blockPosition()) > (double)(distance * distance)).orElse(true);
    }

    public static boolean wantsToStopSitting(TamableMammal entity) {
        Brain<? extends TamableMammal> brain = entity.getBrain();
        if (brain.getMemory(MemoryModuleType.HURT_BY_ENTITY).isPresent()) {
            return true;
        }
        return brain.getMemory((MemoryModuleType)TFCBrain.SIT_TIME.get()).filter(time -> Calendars.SERVER.getTicks() > time + 2000L).isPresent();
    }

    public static boolean wantsToStopSleeping(TamableMammal entity) {
        Brain<? extends TamableMammal> brain = entity.getBrain();
        if (brain.getMemory(MemoryModuleType.HURT_BY_ENTITY).isPresent()) {
            return true;
        }
        return brain.getMemory(MemoryModuleType.LAST_SLEPT).filter(time -> Calendars.SERVER.getTicks() > time + 2000L).isPresent();
    }

    public static void updateActivity(TamableMammal entity, boolean doMoreChecks) {
        Brain<? extends TamableMammal> brain = entity.getBrain();
        Activity current = brain.getActiveNonCoreActivity().orElse(null);
        if (current != null) {
            if (brain.hasMemoryValue(MemoryModuleType.AVOID_TARGET) && TamableAi.couldFlee((LivingEntity)entity)) {
                brain.setActiveActivityIfPossible(Activity.AVOID);
                return;
            }
            if (brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
                brain.setActiveActivityIfPossible(Activity.FIGHT);
            }
            if (doMoreChecks) {
                entity.setInterested(brain.getMemory(MemoryModuleType.LOOK_TARGET).filter(lookTarget -> {
                    EntityTracker entityTracker;
                    return lookTarget instanceof EntityTracker && entity.isOwnedBy((entityTracker = (EntityTracker)lookTarget).getEntity()) && entity.isSitting() && entityTracker.isVisibleBy((LivingEntity)entity);
                }).isPresent());
                boolean farFromHome = TamableAi.isExtremelyFarFromHome(entity);
                if ((current.equals(TFCBrain.HUNT.get()) || current.equals(TFCBrain.FOLLOW.get())) && entity.getOwner() == null) {
                    TamableAi.beginIdle(entity, !farFromHome);
                } else if (current.equals(TFCBrain.IDLE_AT_HOME.get())) {
                    if (farFromHome) {
                        TamableAi.beginIdle(entity, false);
                    } else {
                        brain.getMemory(MemoryModuleType.LAST_SLEPT).ifPresentOrElse(slept -> {
                            if (Calendars.SERVER.getTicks() > slept + 12000L) {
                                brain.setActiveActivityIfPossible(Activity.REST);
                            }
                        }, () -> brain.setMemory(MemoryModuleType.LAST_SLEPT, (Object)0L));
                    }
                } else if (current.equals(TFCBrain.SIT.get()) && TamableAi.wantsToStopSitting(entity)) {
                    TamableAi.beginIdle(entity, !farFromHome);
                } else if (current.equals((Object)Activity.REST) && entity.isSleeping() && TamableAi.wantsToStopSleeping(entity)) {
                    TamableAi.beginIdle(entity, !farFromHome);
                }
            }
        }
    }

    private static void beginIdle(TamableMammal entity, boolean home) {
        entity.setSitting(false);
        entity.setSleeping(false);
        entity.setCommand(TamableMammal.Command.RELAX);
        entity.getBrain().setActiveActivityIfPossible(home ? (Activity)TFCBrain.IDLE_AT_HOME.get() : Activity.IDLE);
    }

    private static boolean couldFlee(LivingEntity entity) {
        return entity.getHealth() < 5.0f || entity.isOnFire();
    }

    private static Optional<? extends LivingEntity> getUnwantedAttackTarget(TamableMammal entity) {
        Brain<? extends TamableMammal> brain = entity.getBrain();
        if (brain.hasMemoryValue(MemoryModuleType.HURT_BY_ENTITY)) {
            return brain.getMemory(MemoryModuleType.HURT_BY_ENTITY);
        }
        return brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(memory -> memory.findClosest(e -> e instanceof Pest));
    }

    private static Optional<? extends LivingEntity> getAttackTarget(TamableMammal entity) {
        Brain<? extends TamableMammal> brain = entity.getBrain();
        if (TamableAi.couldFlee((LivingEntity)entity)) {
            return Optional.empty();
        }
        LivingEntity livingEntity = entity.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            LivingEntity target = player.getLastHurtByMob();
            if (target != null && entity.canAttack(target) && target.tickCount < player.getLastHurtByMobTimestamp() + 120) {
                return Optional.of(target);
            }
            target = player.getLastHurtMob();
            if (target != null && entity.canAttack(target) && target.tickCount < player.getLastHurtMobTimestamp() + 120) {
                return Optional.of(target);
            }
        }
        if (brain.hasMemoryValue(MemoryModuleType.HURT_BY_ENTITY)) {
            return brain.getMemory(MemoryModuleType.HURT_BY_ENTITY);
        }
        return Optional.empty();
    }
}

