/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.mojang.serialization.Dynamic;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.Temptable;
import net.dries007.tfc.common.entities.ai.predator.PackPredatorAi;
import net.dries007.tfc.common.entities.livestock.Gender;
import net.dries007.tfc.common.entities.livestock.pet.Dog;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class PackPredator
extends Predator
implements Temptable {
    public static final EntityDataAccessor<Integer> DATA_RESPECT = SynchedEntityData.defineId(PackPredator.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> DATA_FAMILIARITY = SynchedEntityData.defineId(PackPredator.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private boolean howled;
    private long nextFeedTime = Long.MIN_VALUE;
    private final boolean tamable;

    public static PackPredator createWolf(EntityType<? extends Predator> type, Level level) {
        return new PackPredator(type, level, false, TFCSounds.TFC_WOLF, true);
    }

    public static PackPredator createHyena(EntityType<? extends Predator> type, Level level) {
        return new PackPredator(type, level, false, TFCSounds.HYENA, false);
    }

    public static PackPredator createDirewolf(EntityType<? extends Predator> type, Level level) {
        return new PackPredator(type, level, false, TFCSounds.DOG, false);
    }

    public PackPredator(EntityType<? extends Predator> type, Level level, boolean diurnal, TFCSounds.EntityId sounds, boolean tamable) {
        super(type, level, diurnal, sounds);
        this.tamable = tamable;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficulty, spawnType, spawnData);
        this.setRespect(this.random.nextInt(10));
        return spawnData;
    }

    public int getRespect() {
        return (Integer)this.entityData.get(DATA_RESPECT);
    }

    public void setRespect(int amount) {
        this.entityData.set(DATA_RESPECT, (Object)amount);
    }

    public void addRespect(int amount) {
        this.setRespect(this.getRespect() + amount);
    }

    public float getFamiliarity() {
        return ((Float)this.entityData.get(DATA_FAMILIARITY)).floatValue();
    }

    public void setFamiliarity(float amount) {
        this.entityData.set(DATA_FAMILIARITY, (Object)Float.valueOf(Mth.clamp((float)amount, (float)0.0f, (float)1.0f)));
    }

    public void addFamiliarity(float amount) {
        this.setFamiliarity(this.getFamiliarity() + amount);
    }

    @Override
    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_RESPECT, (Object)0);
        builder.define(DATA_FAMILIARITY, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("respect", this.getRespect());
        tag.putFloat("familiarity", this.getFamiliarity());
        tag.putLong("nextFeed", this.nextFeedTime);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setRespect(EntityHelpers.getIntOrDefault(tag, "respect", 0));
        this.setFamiliarity(EntityHelpers.getFloatOrDefault(tag, "familiarity", 0.0f));
        this.nextFeedTime = EntityHelpers.getLongOrDefault(tag, "nextFeed", Long.MIN_VALUE);
    }

    @Override
    protected Brain.Provider<? extends Predator> brainProvider() {
        return Brain.provider(PackPredatorAi.MEMORY_TYPES, PackPredatorAi.SENSOR_TYPES);
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return PackPredatorAi.makeBrain((Brain<? extends Predator>)this.brainProvider().makeBrain(dynamic), this);
    }

    @Override
    public boolean doHurtTarget(Entity target) {
        if (super.doHurtTarget(target, 10)) {
            if (!target.isAlive()) {
                this.addRespect(this.getRandom().nextInt(3));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        LivingEntity livingEntity;
        Entity entity;
        if (!this.level().isClientSide && (entity = source.getDirectEntity()) instanceof LivingEntity && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingEntity = (LivingEntity)entity)) {
            PackPredatorAi.alertOthers(this, livingEntity);
        } else if (!this.level().isClientSide && this.isSleeping()) {
            PackPredatorAi.alertOthers(this, null);
        }
        return super.hurt(source, amount);
    }

    @Override
    public void tick() {
        super.tick();
        long time = this.level().getDayTime() % 24000L;
        if (!this.howled && time > 18000L && time < 19000L && this.random.nextInt(10) == 0) {
            this.playSound(SoundEvents.WOLF_HOWL, this.getSoundVolume() * 1.2f, this.getVoicePitch());
            this.howled = true;
        }
        if (time > 19000L) {
            this.howled = false;
        }
    }

    public boolean isTamable() {
        return this.tamable;
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return !FoodCapability.isRotten(stack) && this.isTamable() && Helpers.isItem(stack, TFCTags.Items.DOG_FOOD);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        if (this.isFood(held)) {
            long ticks;
            if (!this.level().isClientSide && (ticks = Calendars.SERVER.getTicks()) > this.nextFeedTime) {
                this.addFamiliarity(0.1f);
                this.nextFeedTime = ticks + 24000L;
                if (!player.isCreative()) {
                    held.shrink(1);
                }
                this.playSound(this.getEatingSound(held), this.getSoundVolume(), this.getVoicePitch());
                if (this.getFamiliarity() > 0.99f) {
                    Level level;
                    boolean wasBaby = this.isBaby();
                    Dog dog = (Dog)this.convertTo((EntityType)TFCEntities.DOG.get(), false);
                    if (dog != null && (level = this.level()) instanceof ServerLevelAccessor) {
                        ServerLevelAccessor server = (ServerLevelAccessor)level;
                        dog.finalizeSpawn(server, this.level().getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.CONVERSION, null);
                        dog.setGender(this.isMale() ? Gender.MALE : Gender.FEMALE);
                        if (!wasBaby) {
                            dog.setBirthTickToALongTimeAgo();
                        }
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }
}

