/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.pet.MoveToTargetSinkIfNotSleeping;
import net.dries007.tfc.common.entities.ai.predator.AggressiveSwim;
import net.dries007.tfc.common.entities.ai.predator.PredatorBehaviors;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;

public class PredatorAi {
    public static final ImmutableList<? extends SensorType<? extends Sensor<? super Predator>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY);
    public static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.PACIFIED, (Object[])new MemoryModuleType[]{MemoryModuleType.HOME, MemoryModuleType.HUNTED_RECENTLY, (MemoryModuleType)TFCBrain.WAKEUP_TICKS.get()});
    public static final int MAX_WANDER_DISTANCE = 10000;
    public static final int MAX_ATTACK_DISTANCE = 6400;

    public static Brain<?> makeBrain(Brain<? extends Predator> brain, Predator predator) {
        PredatorAi.initCoreActivity(brain);
        PredatorAi.initHuntActivity(brain);
        PredatorAi.initRetreatActivity(brain);
        PredatorAi.initRestActivity(brain);
        PredatorAi.initFightActivity(brain);
        brain.setSchedule(predator.diurnal ? (Schedule)TFCBrain.DIURNAL.get() : (Schedule)TFCBrain.NOCTURNAL.get());
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity((Activity)TFCBrain.HUNT.get());
        brain.setActiveActivityIfPossible((Activity)TFCBrain.HUNT.get());
        brain.updateActivityFromSchedule(predator.level().getDayTime(), predator.level().getGameTime());
        return brain;
    }

    public static void updateActivity(Predator predator) {
        Brain<Predator> brain = predator.getBrain();
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.FIGHT));
        if (brain.getActiveNonCoreActivity().isPresent()) {
            Activity current = (Activity)brain.getActiveNonCoreActivity().get();
            if (current == Activity.FIGHT && !brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
                brain.updateActivityFromSchedule(predator.level().getDayTime(), predator.level().getGameTime());
            } else if (current == Activity.AVOID && !brain.hasMemoryValue(MemoryModuleType.PACIFIED)) {
                brain.updateActivityFromSchedule(predator.level().getDayTime(), predator.level().getGameTime());
            }
        }
        predator.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    public static void initCoreActivity(Brain<? extends Predator> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)((Object)new AggressiveSwim(0.8f)), (Object)new LookAtTargetSink(45, 90), (Object)((Object)new MoveToTargetSinkIfNotSleeping()), (Object)new CountDownCooldownTicks((MemoryModuleType)TFCBrain.WAKEUP_TICKS.get())));
    }

    public static void initHuntActivity(Brain<? extends Predator> brain) {
        brain.addActivity((Activity)TFCBrain.HUNT.get(), 10, ImmutableList.of(PredatorBehaviors.becomePassiveIf(p -> p.getHealth() < 5.0f, 200), (Object)StartAttacking.create(PredatorAi::getAttackTarget), SetLookTarget.create(8.0f, UniformInt.of((int)30, (int)60)), (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)16), (float)1.25f), PredatorAi.createIdleMovementBehaviors(), PredatorBehaviors.tickScheduleAndWake()));
    }

    public static void initRetreatActivity(Brain<? extends Predator> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)BehaviorBuilder.triggerIf(PredatorAi::hasNearbyAttacker, (OneShot)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY, (float)1.2f, (int)16, (boolean)true)), (Object)StrollToPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)1.2f, (int)5, (int)10000), PredatorAi.createIdleMovementBehaviors()), MemoryModuleType.PACIFIED);
    }

    public static void initRestActivity(Brain<? extends Predator> brain) {
        brain.addActivity(Activity.REST, 10, ImmutableList.of((Object)StartAttacking.create(PredatorAi::getDisturbedAttackTarget), PredatorBehaviors.findNewHome(), (Object)StrollToPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)1.2f, (int)5, (int)10000), PredatorBehaviors.startSleeping(), PredatorBehaviors.tickScheduleAndWake(), PredatorBehaviors.wakeFromDisturbance()));
    }

    public static void initFightActivity(Brain<? extends Predator> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of(PredatorBehaviors.becomePassiveIf(p -> p.getHealth() < 5.0f, 200), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.15f), (Object)MeleeAttack.create((int)40), PredatorBehaviors.stopAttackingIfTooFarFromHome()), MemoryModuleType.ATTACK_TARGET);
    }

    public static RunOne<Predator> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.4f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)0.4f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1), (Object)Pair.of((Object)StrollToPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)0.6f, (int)2, (int)5), (Object)1), (Object)Pair.of((Object)StrollAroundPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)0.6f, (int)10000), (Object)1)));
    }

    public static Optional<? extends LivingEntity> getDisturbedAttackTarget(Predator predator) {
        return predator.getBrain().getMemory((MemoryModuleType)TFCBrain.WAKEUP_TICKS.get()).isPresent() ? PredatorAi.getAttackTarget(predator) : Optional.empty();
    }

    public static Optional<? extends LivingEntity> getAttackTarget(Predator predator) {
        if (PredatorAi.isPacified(predator)) {
            return Optional.empty();
        }
        Brain<Predator> brain = predator.getBrain();
        if (brain.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER)) {
            return brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
        }
        if (brain.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)) {
            NearestVisibleLivingEntities nearestEntities = (NearestVisibleLivingEntities)brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get();
            return nearestEntities.findClosest(e -> Helpers.isEntity((Entity)e, TFCTags.Entities.HUNTED_BY_LAND_PREDATORS) && !e.isInWater());
        }
        return Optional.empty();
    }

    private static boolean isPacified(Predator predator) {
        return predator.isBaby() || predator.getBrain().hasMemoryValue(MemoryModuleType.PACIFIED) || predator.getBrain().hasMemoryValue(MemoryModuleType.HUNTED_RECENTLY);
    }

    public static double getDistanceFromHomeSqr(LivingEntity predator) {
        return predator.blockPosition().distSqr((Vec3i)PredatorAi.getHomePos(predator));
    }

    public static BlockPos getHomePos(LivingEntity predator) {
        Optional memory = predator.getBrain().getMemory(MemoryModuleType.HOME);
        if (memory.isPresent()) {
            return ((GlobalPos)memory.get()).pos();
        }
        predator.getBrain().setMemory(MemoryModuleType.HOME, (Object)GlobalPos.of((ResourceKey)predator.level().dimension(), (BlockPos)predator.blockPosition()));
        return predator.blockPosition();
    }

    public static boolean hasNearbyAttacker(LivingEntity predator) {
        return predator.getBrain().getMemory(MemoryModuleType.HURT_BY_ENTITY).map(entity -> entity.distanceToSqr((Entity)predator) < 256.0).orElse(false);
    }
}

