/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import java.util.Optional;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.pet.MoveOntoBlockBehavior;
import net.dries007.tfc.common.entities.prey.Pest;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class PestFeastBehavior
extends MoveOntoBlockBehavior<Pest> {
    public PestFeastBehavior(MemoryModuleType<?> memory, boolean erase) {
        super(memory, erase);
    }

    @Override
    protected void afterReached(Pest mob) {
        BlockPos pos;
        Level level = mob.level();
        @Nullable IItemHandler itemHandler = (IItemHandler)Helpers.getCapability(Capabilities.ItemHandler.BLOCK, level, pos = mob.blockPosition());
        if (itemHandler != null) {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                if (!Helpers.isItem(itemHandler.getStackInSlot(slot), (TagKey<Item>)Tags.Items.FOODS)) continue;
                mob.setItemSlot(EquipmentSlot.MAINHAND, itemHandler.extractItem(slot, 1, false));
                for (int i = 1; i < 6; ++i) {
                    Helpers.tickInfestation(level, pos, i, null);
                }
                return;
            }
            mob.getBrain().eraseMemory((MemoryModuleType)TFCBrain.SMELLY_POS.get());
        }
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, Pest animal) {
        return super.checkExtraStartConditions(level, animal) && animal.getMainHandItem().isEmpty();
    }

    @Override
    protected Optional<BlockPos> getNearestTarget(Pest mob) {
        return mob.getBrain().getMemory((MemoryModuleType)TFCBrain.SMELLY_POS.get()).map(GlobalPos::pos);
    }

    @Override
    protected boolean isTargetAt(ServerLevel level, BlockPos pos) {
        return level.getBlockEntity(pos) != null;
    }
}

