/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.livestock.pet.TFCCat;
import net.dries007.tfc.mixin.accessor.OcelotAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class TFCOcelot
extends Ocelot {
    public static final EntityDataAccessor<Float> DATA_FAMILIARITY = SynchedEntityData.defineId(TFCOcelot.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private long nextFeedTime = Long.MIN_VALUE;

    public TFCOcelot(EntityType<? extends Ocelot> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        EntityHelpers.removeGoalOfPriority(this.goalSelector, 3);
        EntityHelpers.removeGoalOfPriority(this.goalSelector, 9);
        EntityHelpers.removeGoalOfPriority(this.targetSelector, 1);
        this.goalSelector.addGoal(3, (Goal)new OcelotTemptGoal(this, 0.6, Ingredient.of(TFCTags.Items.CAT_FOOD), true));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, e -> !(e instanceof Player) && Helpers.isEntity((Entity)e, TFCTags.Entities.HUNTED_BY_CATS)));
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    public float getFamiliarity() {
        return ((Float)this.entityData.get(DATA_FAMILIARITY)).floatValue();
    }

    public void setFamiliarity(float amount) {
        this.entityData.set(DATA_FAMILIARITY, (Object)Float.valueOf(Mth.clamp((float)amount, (float)0.0f, (float)1.0f)));
    }

    public void addFamiliarity(float amount) {
        this.setFamiliarity(this.getFamiliarity() + amount);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FAMILIARITY, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("familiarity", this.getFamiliarity());
        tag.putLong("nextFeed", this.nextFeedTime);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setFamiliarity(EntityHelpers.getFloatOrDefault(tag, "familiarity", 0.0f));
        this.nextFeedTime = EntityHelpers.getLongOrDefault(tag, "nextFeed", Long.MIN_VALUE);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        if (this.isFood(held)) {
            long ticks;
            if (!this.level().isClientSide && (ticks = Calendars.SERVER.getTicks()) > this.nextFeedTime) {
                this.addFamiliarity(0.1f);
                ((OcelotAccessor)((Object)this)).invoke$setTrusting(true);
                this.nextFeedTime = ticks + 24000L;
                if (!player.isCreative()) {
                    held.shrink(1);
                }
                this.playSound(this.getEatingSound(held), this.getSoundVolume(), this.getVoicePitch());
                if (this.getFamiliarity() > 0.99f) {
                    Level level;
                    boolean wasBaby = this.isBaby();
                    TFCCat cat = (TFCCat)this.convertTo((EntityType)TFCEntities.CAT.get(), false);
                    if (cat != null && (level = this.level()) instanceof ServerLevelAccessor) {
                        ServerLevelAccessor server = (ServerLevelAccessor)level;
                        cat.finalizeSpawn(server, this.level().getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.CONVERSION, null);
                        if (!wasBaby) {
                            cat.setBirthTickToALongTimeAgo();
                        }
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public boolean isFood(ItemStack stack) {
        return !FoodCapability.isRotten(stack) && Helpers.isItem(stack, TFCTags.Items.CAT_FOOD);
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this) && !level.containsAnyLiquid(this.getBoundingBox());
    }

    public void setInLove(@Nullable Player player) {
    }

    public static class OcelotTemptGoal
    extends TemptGoal {
        private final Ocelot ocelot;

        public OcelotTemptGoal(Ocelot ocelot, double speedMod, Ingredient ingredient, boolean canScare) {
            super((PathfinderMob)ocelot, speedMod, (Predicate)ingredient, canScare);
            this.ocelot = ocelot;
        }

        protected boolean canScare() {
            return super.canScare() && !((OcelotAccessor)this.ocelot).invoke$isTrusting();
        }
    }
}

