/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.ProducingMammal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.animals.ProducingMammalConfig;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public abstract class DairyAnimal
extends ProducingMammal {
    public DairyAnimal(EntityType<? extends DairyAnimal> animal, Level level, TFCSounds.EntityId sounds, ProducingMammalConfig config) {
        super(animal, level, sounds, config);
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        @Nullable IFluidHandlerItem destFluidItemHandler = (IFluidHandlerItem)held.copy().getCapability(Capabilities.FluidHandler.ITEM);
        if (!held.isEmpty() && destFluidItemHandler != null) {
            if ((double)this.getFamiliarity() > (Double)this.produceFamiliarity.get() && this.isReadyForAnimalProduct()) {
                FluidStack milk = new FluidStack(this.getMilkFluid(), 1000);
                AnimalProductEvent event = new AnimalProductEvent(this.level(), this.blockPosition(), player, (TFCAnimalProperties)this, milk, held, 1);
                if (!((AnimalProductEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                    FluidTank sourceFluidHandler = new FluidTank(Integer.MAX_VALUE);
                    sourceFluidHandler.setFluid(event.getFluidProduct());
                    FluidHelpers.transferBetweenItemAndOther(held, destFluidItemHandler, (IFluidHandler)sourceFluidHandler, (IFluidHandler)destFluidItemHandler, sound -> player.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f), FluidHelpers.with(player, hand));
                    this.setProductsCooldown();
                    this.addUses(event.getUses());
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
            } else {
                this.sendTooltip(this.level(), player);
            }
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public boolean hasProduct() {
        return this.isFemale() && this.getAgeType() == Age.ADULT && this.getProductsCooldown() == 0L;
    }

    private void sendTooltip(Level level, Player player) {
        MutableComponent component = null;
        if (this.isMale()) {
            component = Component.translatable((String)"tfc.tooltip.animal.male_milk", (Object[])new Object[]{this.getTypeName().getString()});
        } else if (this.getAgeType() == Age.OLD) {
            component = Component.translatable((String)"tfc.tooltip.animal.old", (Object[])new Object[]{this.getTypeName().getString()});
        } else if (this.getAgeType() == Age.CHILD) {
            component = Component.translatable((String)"tfc.tooltip.animal.young", (Object[])new Object[]{this.getTypeName().getString()});
        } else if ((double)this.getFamiliarity() <= (Double)this.produceFamiliarity.get()) {
            component = Component.translatable((String)"tfc.tooltip.animal.low_familiarity", (Object[])new Object[]{this.getTypeName().getString()});
        } else if (!this.hasProduct()) {
            component = Component.translatable((String)"tfc.tooltip.animal.no_milk", (Object[])new Object[]{this.getTypeName().getString()});
        }
        if (component != null && level.isClientSide) {
            player.displayClientMessage((Component)component, true);
        }
    }

    public Fluid getMilkFluid() {
        return (Fluid)NeoForgeMod.MILK.get();
    }

    @Override
    public MutableComponent getProductReadyName() {
        return Component.translatable((String)"tfc.jade.product.milk");
    }
}

