/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.animals.MammalConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface MammalProperties
extends TFCAnimalProperties {
    public MammalConfig getMammalConfig();

    public long getPregnantTime();

    public void setPregnantTime(long var1);

    @Nullable
    public CompoundTag getGenes();

    public void setGenes(@Nullable CompoundTag var1);

    @Override
    default public void tickAnimalData() {
        TFCAnimalProperties.super.tickAnimalData();
        Level level = this.getEntity().level();
        if (!level.isClientSide && level.getGameTime() % 20L == 0L && this.getPregnantTime() > 0L && Calendars.SERVER.getTotalDays() >= this.getPregnantTime() + this.getGestationDays() && this.isFertilized()) {
            this.birthChildren();
            this.setFertilized(false);
            this.setPregnantTime(-1L);
            this.addUses(10);
        }
    }

    default public void birthChildren() {
        LivingEntity entity = this.getEntity();
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (entity instanceof AgeableMob) {
                AgeableMob ageable = (AgeableMob)entity;
                RandomSource random = entity.getRandom();
                int kids = Mth.nextInt((RandomSource)random, (int)1, (int)this.getChildCount());
                for (int i = 0; i < kids; ++i) {
                    AgeableMob offspring = ageable.getBreedOffspring(server, ageable);
                    if (offspring == null || !(offspring instanceof MammalProperties)) continue;
                    MammalProperties animal = (MammalProperties)offspring;
                    offspring.setPos(entity.position());
                    animal.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
                    server.addFreshEntity((Entity)offspring);
                }
            }
        }
    }

    @Override
    default public boolean isReadyToMate() {
        return this.getPregnantTime() <= 0L && TFCAnimalProperties.super.isReadyToMate();
    }

    @Override
    default public void onFertilized(TFCAnimalProperties male) {
        TFCAnimalProperties.super.onFertilized(male);
        this.setPregnantTime(this.calendar().getTotalDays());
        CompoundTag genes = new CompoundTag();
        this.createGenes(genes, male);
        this.setGenes(genes.isEmpty() ? null : genes);
    }

    default public void createGenes(CompoundTag tag, TFCAnimalProperties male) {
        tag.putInt("size", male.getGeneticSize() + this.getGeneticSize());
        tag.putBoolean("runt", this.getEntity().getRandom().nextInt(20) == 0);
    }

    @Override
    default public void setBabyTraits(TFCAnimalProperties baby) {
        TFCAnimalProperties.super.setBabyTraits(baby);
        if (this.getGenes() != null) {
            this.applyGenes(this.getGenes(), (MammalProperties)baby);
        }
    }

    default public void applyGenes(CompoundTag tag, MammalProperties baby) {
        baby.setGeneticSize(Mth.floor((double)((double)EntityHelpers.getIntOrDefault(tag, "size", 16) / 2.0 + (double)Mth.nextInt((RandomSource)baby.getEntity().getRandom(), (int)-3, (int)3))));
        if (tag.getBoolean("runt")) {
            baby.setGeneticSize(1);
        }
    }

    @Override
    default public void showExtraClickInfo(Player player) {
        if (this.isFertilized()) {
            player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.animal.pregnant", (Object[])new Object[]{this.getEntity().getName().getString()}), true);
        }
    }

    @Override
    default public void saveCommonAnimalData(CompoundTag nbt) {
        TFCAnimalProperties.super.saveCommonAnimalData(nbt);
        nbt.putLong("pregnant", this.getPregnantTime());
        if (this.getGenes() != null) {
            nbt.put("genes", (Tag)this.getGenes());
        }
    }

    @Override
    default public void readCommonAnimalData(CompoundTag nbt) {
        TFCAnimalProperties.super.readCommonAnimalData(nbt);
        this.setPregnantTime(nbt.getLong("pregnant"));
        if (nbt.contains("genes")) {
            this.setGenes(nbt.getCompound("genes"));
        }
    }

    default public int getChildCount() {
        return this.getMammalConfig().childCount().get();
    }

    default public long getGestationDays() {
        return this.getMammalConfig().gestationDays().get().intValue();
    }
}

