/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.component.EggComponent;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.Pluckable;
import net.dries007.tfc.common.entities.ai.livestock.LivestockAi;
import net.dries007.tfc.common.entities.ai.livestock.OviparousAi;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.Gender;
import net.dries007.tfc.common.entities.livestock.ProducingAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.animals.OviparousAnimalConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public abstract class OviparousAnimal
extends ProducingAnimal
implements Pluckable {
    public float flapping = 1.0f;
    public float oFlap;
    public float flap;
    public float oFlapSpeed;
    public float flapSpeed;
    private float nextFlap = 1.0f;
    private final Supplier<Integer> hatchDays;
    private long lastPlucked = Long.MIN_VALUE;
    private boolean crowed;
    private final boolean isCrowingBird;
    private final EntityDimensions babyDims;

    public static AttributeSupplier.Builder createAttributes() {
        return Chicken.createAttributes().add(Attributes.STEP_HEIGHT, 1.5);
    }

    public OviparousAnimal(EntityType<? extends OviparousAnimal> type, Level level, TFCSounds.EntityId sounds, OviparousAnimalConfig config, boolean isCrowingBird) {
        super(type, level, sounds, config.inner());
        this.isCrowingBird = isCrowingBird;
        this.hatchDays = config.hatchDays();
        this.babyDims = type.getDimensions().scale(0.5f).withEyeHeight(0.2975f);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isBaby() ? this.babyDims : super.getDefaultDimensions(pose);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        EntityHelpers.getLongOrDefault(tag, "plucked", Long.MIN_VALUE);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putLong("plucked", this.lastPlucked);
    }

    @Override
    public long getLastPluckedTick() {
        return this.lastPlucked;
    }

    @Override
    public void setLastPluckedTick(long tick) {
        this.lastPlucked = tick;
    }

    protected float getJumpPower() {
        if (!this.moveControl.hasWanted() || this.moveControl.getWantedY() <= this.getY() + 0.5 && this.moveControl.getSpeedModifier() > (double)1.1f) {
            return super.getJumpPower() * 1.2f;
        }
        return super.getJumpPower();
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.level().getGameTime() % 20L == 0L && this.random.nextInt(3) == 0 && this.getBrain().getActiveNonCoreActivity().filter(p -> p == Activity.AVOID).isPresent()) {
            this.getJumpControl().jump();
        }
    }

    @Override
    public void tick() {
        super.tick();
        long time = this.level().getDayTime() % 24000L;
        if (this.isCrowingBird && !this.crowed && time > 0L && time < 1000L && this.random.nextInt(10) == 0) {
            if (this.isMale()) {
                this.playSound((SoundEvent)TFCSounds.ROOSTER_CRY.get(), this.getSoundVolume() * 1.2f, this.getVoicePitch());
            } else if (this.getAmbientSound() != null) {
                this.playSound(this.getAmbientSound(), this.getSoundVolume() * 0.5f, this.getVoicePitch());
            }
            this.crowed = true;
        }
        if (time > 1000L) {
            this.crowed = false;
        }
    }

    protected Brain.Provider<? extends OviparousAnimal> brainProvider() {
        return Brain.provider(OviparousAi.MEMORY_TYPES, OviparousAi.SENSOR_TYPES);
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return OviparousAi.makeBrain((Brain<? extends OviparousAnimal>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<? extends OviparousAnimal> getBrain() {
        return super.getBrain();
    }

    @Override
    public void tickBrain() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        LivestockAi.updateActivity(this);
    }

    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    protected void onFlap() {
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    public void aiStep() {
        super.aiStep();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.onGround() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (this.isPassenger()) {
            this.flapSpeed = 0.0f;
        }
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 move = this.getDeltaMovement();
        if (!this.onGround() && move.y < 0.0) {
            this.setDeltaMovement(move.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    @Override
    public boolean hasProduct() {
        return this.isFemale() && this.getAgeType() == Age.ADULT && (this.getProducedTick() <= 0L || this.getProductsCooldown() <= 0L);
    }

    public boolean causeFallDamage(float amount, float speed, DamageSource src) {
        return false;
    }

    public ItemStack makeEgg() {
        AnimalProductEvent event;
        OviparousAnimal baby;
        ItemStack stack = new ItemStack((ItemLike)Items.EGG);
        if (this.isFertilized() && (baby = (OviparousAnimal)this.getType().create(this.level())) != null) {
            baby.setGender(Gender.valueOf(this.random.nextBoolean()));
            baby.setBirthTickNow();
            baby.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
            stack.set(TFCComponents.EGG, (Object)EggComponent.of(baby, Calendars.SERVER.getTotalDays() + (long)this.hatchDays.get().intValue()));
            FoodCapability.setInvisibleNonDecaying(stack);
        }
        if (!((AnimalProductEvent)NeoForge.EVENT_BUS.post((Event)(event = new AnimalProductEvent(this.level(), this.blockPosition(), null, (TFCAnimalProperties)this, stack, ItemStack.EMPTY, 1)))).isCanceled()) {
            this.addUses(event.getUses());
        }
        return event.getProduct();
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        return this.pluck(player, hand, (LivingEntity)this) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide) : super.mobInteract(player, hand);
    }

    @Override
    public MutableComponent getProductReadyName() {
        return Component.translatable((String)"tfc.jade.product.eggs");
    }
}

