/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.livestock.Mammal;
import net.dries007.tfc.config.animals.ProducingMammalConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public abstract class ProducingMammal
extends Mammal {
    public static final EntityDataAccessor<Long> DATA_PRODUCED = SynchedEntityData.defineId(ProducingMammal.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    protected final Supplier<Integer> produceTicks;
    protected final Supplier<Double> produceFamiliarity;

    public ProducingMammal(EntityType<? extends ProducingMammal> animal, Level level, TFCSounds.EntityId sounds, ProducingMammalConfig config) {
        super(animal, level, sounds, config.inner());
        this.produceTicks = config.produceTicks();
        this.produceFamiliarity = config.produceFamiliarity();
    }

    @Override
    public boolean isReadyForAnimalProduct() {
        return (double)this.getFamiliarity() > this.produceFamiliarity.get() && this.hasProduct();
    }

    @Override
    public void setProductsCooldown() {
        this.setProducedTick(Calendars.get((LevelReader)this.level()).getTicks());
    }

    @Override
    public long getProductsCooldown() {
        return Math.max(0L, (long)this.produceTicks.get().intValue() + this.getProducedTick() - Calendars.get((LevelReader)this.level()).getTicks());
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putLong("produced", this.getProducedTick());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setProducedTick(nbt.getLong("produced"));
    }

    @Override
    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PRODUCED, (Object)0L);
    }

    public long getProducedTick() {
        return (Long)this.entityData.get(DATA_PRODUCED);
    }

    public void setProducedTick(long producedTick) {
        this.entityData.set(DATA_PRODUCED, (Object)producedTick);
    }
}

