/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.horse;

import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import net.dries007.tfc.common.effect.TFCEffects;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface HorseProperties
extends MammalProperties {
    public static final AttributeModifier OLD_AGE_MODIFIER = new AttributeModifier(Helpers.identifier("old_age"), -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final float TAMED_FAMILIARITY = 0.15f;
    public static final float MIN_MOVEMENT_SPEED = (float)HorseProperties.generateSpeed(() -> 0.0);
    public static final float MAX_MOVEMENT_SPEED = (float)HorseProperties.generateSpeed(() -> 1.0);
    public static final float MIN_JUMP_STRENGTH = (float)HorseProperties.generateJumpStrength(() -> 0.0);
    public static final float MAX_JUMP_STRENGTH = (float)HorseProperties.generateJumpStrength(() -> 1.0);
    public static final float MIN_HEALTH = HorseProperties.generateMaxHealth(v -> 0);
    public static final float MAX_HEALTH = HorseProperties.generateMaxHealth(v -> 1);

    public static float generateMaxHealth(IntUnaryOperator supplier) {
        return 15.0f + (float)supplier.applyAsInt(8) + (float)supplier.applyAsInt(9);
    }

    public static double generateJumpStrength(DoubleSupplier supplier) {
        return 0.4 + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2;
    }

    public static double generateSpeed(DoubleSupplier supplier) {
        return (0.45 + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3) * 0.25;
    }

    default public AbstractHorse getEntity() {
        return (AbstractHorse)MammalProperties.super.getEntity();
    }

    @Override
    default public void createGenes(CompoundTag tag, TFCAnimalProperties maleProperties) {
        MammalProperties.super.createGenes(tag, maleProperties);
        AbstractHorse female = this.getEntity();
        AbstractHorse male = (AbstractHorse)maleProperties;
        tag.putDouble("maxHealth1", male.getAttributeBaseValue(Attributes.MAX_HEALTH));
        tag.putDouble("maxHealth2", female.getAttributeBaseValue(Attributes.MAX_HEALTH));
        tag.putDouble("jumpStrength1", male.getAttributeBaseValue(Attributes.JUMP_STRENGTH));
        tag.putDouble("jumpStrength2", female.getAttributeBaseValue(Attributes.JUMP_STRENGTH));
        tag.putDouble("movementSpeed1", male.getAttributeBaseValue(Attributes.MOVEMENT_SPEED));
        tag.putDouble("movementSpeed2", male.getAttributeBaseValue(Attributes.MOVEMENT_SPEED));
    }

    @Override
    default public void applyGenes(CompoundTag tag, MammalProperties babyProperties) {
        MammalProperties.super.applyGenes(tag, babyProperties);
        AbstractHorse baby = (AbstractHorse)babyProperties;
        double maxHealth = tag.contains("maxHealth1", 6) ? EntityHelpers.createOffspringAttribute(tag.getDouble("maxHealth1"), tag.getDouble("maxHealth2"), MIN_HEALTH, MAX_HEALTH, this.getEntity().getRandom()) : (double)HorseProperties.generateMaxHealth(i -> this.getEntity().getRandom().nextInt());
        double jumpStrength = tag.contains("jumpStrength1", 6) ? EntityHelpers.createOffspringAttribute(tag.getDouble("jumpStrength1"), tag.getDouble("jumpStrength2"), MIN_JUMP_STRENGTH, MAX_JUMP_STRENGTH, this.getEntity().getRandom()) : HorseProperties.generateJumpStrength(() -> this.getEntity().getRandom().nextDouble());
        double speed = tag.contains("movementSpeed1", 6) ? EntityHelpers.createOffspringAttribute(tag.getDouble("movementSpeed1"), tag.getDouble("movementSpeed2"), MIN_MOVEMENT_SPEED, MAX_MOVEMENT_SPEED, this.getEntity().getRandom()) : HorseProperties.generateSpeed(() -> this.getEntity().getRandom().nextDouble());
        EntityHelpers.setNullableAttribute((LivingEntity)baby, (Holder<Attribute>)Attributes.JUMP_STRENGTH, jumpStrength);
        EntityHelpers.setNullableAttribute((LivingEntity)baby, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, speed);
        EntityHelpers.setNullableAttribute((LivingEntity)baby, (Holder<Attribute>)Attributes.MAX_HEALTH, maxHealth);
    }

    @Override
    default public SoundEvent eatingSound(ItemStack stack) {
        return this.getEntity().getEatingSound(stack);
    }

    @Override
    default public void tickAnimalData() {
        AttributeInstance speed;
        MammalProperties.super.tickAnimalData();
        if (!this.getEntity().level().isClientSide() && this.isMale() && this.isReadyToMate()) {
            EntityHelpers.findFemaleMate((Animal)this);
        }
        if (this.getAgeType() == Age.OLD && (speed = this.getEntity().getAttribute(Attributes.MOVEMENT_SPEED)) != null && !speed.hasModifier(OLD_AGE_MODIFIER.id())) {
            speed.addTransientModifier(OLD_AGE_MODIFIER);
        }
        for (Entity entity : this.getEntity().getPassengers()) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).hasEffect(TFCEffects.OVERBURDENED.holder())) continue;
            this.rejectPassengers();
            if (!(livingEntity instanceof Player)) break;
            Player player = (Player)livingEntity;
            player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.animal.horse_angry_overburdened"), true);
            break;
        }
    }

    default public void rejectPassengers() {
        AbstractHorse horse = this.getEntity();
        horse.ejectPassengers();
        horse.makeMad();
        horse.level().broadcastEntityEvent((Entity)horse, (byte)6);
    }
}

