/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.pet;

import java.util.List;
import java.util.Optional;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.livestock.pet.TamableMammal;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.CatVariantTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class TFCCat
extends TamableMammal {
    public static final EntityDataAccessor<Holder<CatVariant>> DATA_VARIANT = SynchedEntityData.defineId(TFCCat.class, (EntityDataSerializer)EntityDataSerializers.CAT_VARIANT);
    private static final List<ResourceKey<CatVariant>> LEGACY_CAT_VARIANTS = List.of(CatVariant.TABBY, CatVariant.BLACK, CatVariant.RED, CatVariant.SIAMESE, CatVariant.BRITISH_SHORTHAIR, CatVariant.CALICO, CatVariant.PERSIAN, CatVariant.RAGDOLL, CatVariant.WHITE, CatVariant.JELLIE, CatVariant.ALL_BLACK);

    public TFCCat(EntityType<? extends TamableMammal> type, Level level) {
        super(type, level, TFCSounds.CAT, TFCConfig.SERVER.catConfig);
    }

    @Override
    public boolean willListenTo(TamableMammal.Command command, boolean isClientSide) {
        if (!isClientSide && command == TamableMammal.Command.SIT && this.getRandom().nextFloat() < 0.1f) {
            return false;
        }
        return super.willListenTo(command, isClientSide);
    }

    @Override
    public void createGenes(CompoundTag tag, TFCAnimalProperties male) {
        super.createGenes(tag, male);
        if (male instanceof TFCCat) {
            TFCCat maleCat = (TFCCat)male;
            tag.putString("variant", this.random.nextBoolean() ? maleCat.getVariant().toString() : this.getVariant().toString());
        }
    }

    @Override
    public void applyGenes(CompoundTag tag, MammalProperties baby) {
        super.applyGenes(tag, baby);
        if (baby instanceof TFCCat) {
            TFCCat cat = (TFCCat)baby;
            BuiltInRegistries.CAT_VARIANT.getHolder(CatVariant.BLACK).ifPresent(this::setVariant);
        }
    }

    @Override
    public void initCommonAnimalData(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason) {
        super.initCommonAnimalData(level, difficulty, reason);
        boolean fullMoon = level.getMoonBrightness() > 0.9f;
        TagKey key = fullMoon ? CatVariantTags.FULL_MOON_SPAWNS : CatVariantTags.DEFAULT_SPAWNS;
        BuiltInRegistries.CAT_VARIANT.getOrCreateTag(key).getRandomElement(this.random).ifPresent(this::setVariant);
        ServerLevel serverlevel = level.getLevel();
        if (serverlevel.structureManager().getStructureWithPieceAt(this.blockPosition(), StructureTags.CATS_SPAWN_AS_BLACK).isValid()) {
            this.setVariant((Holder<CatVariant>)BuiltInRegistries.CAT_VARIANT.getHolderOrThrow(CatVariant.ALL_BLACK));
            this.setPersistenceRequired();
        }
    }

    @Override
    public boolean canAttack(LivingEntity entity) {
        return super.canAttack(entity) && Helpers.isEntity((Entity)entity, TFCTags.Entities.HUNTED_BY_CATS);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT, (Object)BuiltInRegistries.CAT_VARIANT.getHolderOrThrow(CatVariant.BLACK));
    }

    public CatVariant getVariant() {
        return (CatVariant)((Holder)this.entityData.get(DATA_VARIANT)).value();
    }

    public void setVariant(Holder<CatVariant> type) {
        this.entityData.set(DATA_VARIANT, type);
    }

    public ResourceLocation getTextureLocation() {
        return this.getVariant().texture();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        ResourceLocation key = BuiltInRegistries.CAT_VARIANT.getKey((Object)this.getVariant());
        if (key != null) {
            tag.putString("variant", key.toString());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("variant", 8)) {
            Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString("variant"))).flatMap(arg_0 -> ((Registry)BuiltInRegistries.CAT_VARIANT).getHolder(arg_0)).ifPresent(this::setVariant);
        }
    }

    @Override
    public TagKey<Item> getFoodTag() {
        return TFCTags.Items.CAT_FOOD;
    }

    @Override
    public void receiveCommand(ServerPlayer player, TamableMammal.Command command) {
        if (this.getOwner() != null && this.getOwner().equals((Object)player)) {
            this.playSound(SoundEvents.CAT_PURREOW, this.getSoundVolume(), this.getVoicePitch());
        }
        super.receiveCommand(player, command);
    }
}

