/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.misc;

import java.util.function.IntConsumer;
import net.dries007.tfc.common.blockentities.PowderkegBlockEntity;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.item.ItemListComponent;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.PowderKegExplosion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class HoldingMinecart
extends AbstractMinecart {
    public static final EntityDataAccessor<ItemStack> DATA_HOLD_ITEM = SynchedEntityData.defineId(HoldingMinecart.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private int fuse = -1;

    public static void copyMinecart(AbstractMinecart oldCart, AbstractMinecart newCart) {
        newCart.setYRot(oldCart.getYRot());
        newCart.setXRot(oldCart.getXRot());
        newCart.setDeltaMovement(oldCart.getDeltaMovement());
        if (oldCart.hasCustomName()) {
            newCart.setCustomName(oldCart.getCustomName());
        }
    }

    public HoldingMinecart(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public HoldingMinecart(Level level, double x, double y, double z) {
        super((EntityType)TFCEntities.HOLDING_MINECART.get(), level, x, y, z);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player.isSecondaryUseActive() && player.isShiftKeyDown() && player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.level().isClientSide) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.getPickResult());
            this.setHoldItem(ItemStack.EMPTY);
            Minecart minecart = new Minecart(this.level(), this.getX(), this.getY(), this.getZ());
            HoldingMinecart.copyMinecart(this, (AbstractMinecart)minecart);
            this.discard();
            this.level().addFreshEntity((Entity)minecart);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.CHEST;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("holdItem", this.getHoldItem().save((HolderLookup.Provider)this.registryAccess()));
        tag.putInt("TNTFuse", this.fuse);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setHoldItem(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)tag.getCompound("holdItem")));
        this.fuse = EntityHelpers.getIntOrDefault(tag, "TNTFuse", -1);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_HOLD_ITEM, (Object)ItemStack.EMPTY);
    }

    public ItemStack getHoldItem() {
        return (ItemStack)this.entityData.get(DATA_HOLD_ITEM);
    }

    public void setHoldItem(ItemStack item) {
        this.entityData.set(DATA_HOLD_ITEM, (Object)item.copy());
    }

    @NotNull
    public ItemStack getPickResult() {
        return ((ItemStack)this.entityData.get(DATA_HOLD_ITEM)).copy();
    }

    public BlockState getDisplayBlockState() {
        ItemStack stack = this.getHoldItem();
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState state = blockItem.getBlock().defaultBlockState();
            if (state.hasProperty((Property)SealableDeviceBlock.SEALED) && (stack.has(TFCComponents.BARREL) || stack.has(TFCComponents.CONTENTS))) {
                state = (BlockState)state.setValue((Property)SealableDeviceBlock.SEALED, (Comparable)Boolean.valueOf(true));
            }
            if (state.hasProperty((Property)PowderkegBlock.LIT) && this.isPrimed()) {
                state = (BlockState)state.setValue((Property)PowderkegBlock.LIT, (Comparable)Boolean.valueOf(true));
            }
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public void destroy(DamageSource source) {
        super.destroy(source);
        if ((Helpers.isDamageSource(source, (TagKey<DamageType>)DamageTypeTags.IS_FIRE) || Helpers.isDamageSource(source, (TagKey<DamageType>)DamageTypeTags.IS_EXPLOSION)) && this.ifPowderkeg(this::explode)) {
            return;
        }
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            this.spawnAtLocation(this.getHoldItem().copy());
        }
    }

    protected Item getDropItem() {
        return Items.MINECART;
    }

    public boolean hasCustomDisplay() {
        return true;
    }

    public boolean causeFallDamage(float distance, float multiplier, DamageSource source) {
        if (distance >= 3.0f) {
            this.ifPowderkeg(this::explode);
        }
        return super.causeFallDamage(distance, multiplier, source);
    }

    public void activateMinecart(int x, int y, int z, boolean powered) {
        if (powered && this.fuse < 0) {
            this.primeFuse();
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 10) {
            this.primeFuse();
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void primeFuse() {
        this.ifPowderkeg(str -> {
            this.fuse = 80;
            if (!this.level().isClientSide) {
                this.level().broadcastEntityEvent((Entity)this, (byte)10);
                if (!this.isSilent()) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        });
    }

    public boolean isPrimed() {
        return this.fuse > -1;
    }

    public void tick() {
        super.tick();
        this.ifPowderkeg(strength -> {
            double delta;
            if (this.fuse > 0) {
                --this.fuse;
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
            } else if (this.fuse == 0) {
                this.explode(strength);
            }
            if (this.horizontalCollision && (delta = this.getDeltaMovement().horizontalDistanceSqr()) >= (double)0.01f) {
                this.explode(strength);
            }
        });
    }

    public boolean hurt(DamageSource source, float amount) {
        AbstractArrow arrow;
        Entity entity = source.getDirectEntity();
        if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).isOnFire()) {
            this.ifPowderkeg(this::explode);
        }
        return super.hurt(source, amount);
    }

    protected void explode(int strength) {
        if (!this.level().isClientSide) {
            PowderKegExplosion explosion = new PowderKegExplosion(this.level(), null, this.getX(), this.getY(), this.getZ(), strength);
            explosion.explode();
            explosion.finalizeExplosion(true);
            explosion.sendExplosionPacketToClients();
            this.discard();
        }
    }

    public boolean ifPowderkeg(IntConsumer toRun) {
        if (!TFCConfig.SERVER.powderKegEnabled.get().booleanValue()) {
            return false;
        }
        int strength = this.getPowderkegStrength();
        if (strength != -1) {
            toRun.accept(strength);
            return true;
        }
        return false;
    }

    public int getPowderkegStrength() {
        ItemListComponent contents;
        PowderkegBlock keg;
        BlockItem bi;
        ItemStack stack = this.getHoldItem();
        Item item = stack.getItem();
        if (item instanceof BlockItem && (item = (bi = (BlockItem)item).getBlock()) instanceof PowderkegBlock && (keg = (PowderkegBlock)item).isStackSealed(stack) && (contents = (ItemListComponent)stack.get(TFCComponents.CONTENTS)) != null) {
            return PowderkegBlockEntity.getStrength(contents);
        }
        return -1;
    }
}

