/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.misc;

import java.util.function.Supplier;
import net.dries007.tfc.common.entities.misc.TFCChestBoat;
import net.dries007.tfc.common.items.ChestBlockItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TFCBoat
extends Boat {
    private final Supplier<EntityType<TFCChestBoat>> boatChest;
    private final Supplier<? extends Item> drop;

    public TFCBoat(EntityType<? extends Boat> type, Level level, Supplier<EntityType<TFCChestBoat>> boatChest, Supplier<? extends Item> drop) {
        super(type, level);
        this.boatChest = boatChest;
        this.drop = drop;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        TFCChestBoat boat;
        ItemStack item = player.getItemInHand(hand);
        if (item.getItem() instanceof ChestBlockItem && (boat = (TFCChestBoat)this.boatChest.get().create(player.level())) != null) {
            boat.setPos(this.position());
            boat.setYRot(this.getYRot());
            boat.setXRot(this.getXRot());
            boat.setDeltaMovement(this.getDeltaMovement());
            if (this.hasCustomName()) {
                boat.setCustomName(this.getCustomName());
            }
            boat.setChestItem(item.split(1));
            this.level().addFreshEntity((Entity)boat);
            this.discard();
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.interact(player, hand);
    }

    public Item getDropItem() {
        return this.drop.get();
    }
}

