/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.misc;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.rock.IFallableBlock;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.LandslideRecipe;
import net.dries007.tfc.mixin.accessor.FallingBlockEntityAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TFCFallingBlockEntity
extends FallingBlockEntity {
    private final boolean dontSetBlock;
    private boolean failedBreakCheck = false;

    public static boolean canFallThrough(BlockGetter world, BlockPos pos, BlockState state) {
        return !state.isFaceSturdy(world, pos, Direction.UP);
    }

    public static boolean canFallInDirection(BlockGetter level, BlockPos pos, Direction fallingDirection) {
        BlockPos fallThroughPos = pos.relative(fallingDirection);
        return TFCFallingBlockEntity.canFallThrough(level, fallThroughPos, level.getBlockState(fallThroughPos), fallingDirection, level.getBlockState(pos));
    }

    public static boolean canFallThrough(BlockGetter level, BlockPos pos, Direction fallingDirection) {
        BlockState state = level.getBlockState(pos);
        return TFCFallingBlockEntity.canFallThrough(level, pos, state, fallingDirection, state);
    }

    public static boolean canFallThrough(BlockGetter level, BlockPos pos, Direction fallingDirection, BlockState fallingState) {
        return TFCFallingBlockEntity.canFallThrough(level, pos, level.getBlockState(pos), fallingDirection, fallingState);
    }

    public static boolean canFallThrough(BlockGetter level, BlockPos pos, BlockState state, Direction fallingDirection, BlockState fallingState) {
        return !state.isFaceSturdy(level, pos, fallingDirection.getOpposite()) && TFCFallingBlockEntity.getBlockToughness(fallingState) >= TFCFallingBlockEntity.getBlockToughness(state) && state.getDestroySpeed(level, pos) > -1.0f && state.getBlock() != Blocks.STRUCTURE_VOID;
    }

    public static int getBlockToughness(BlockState state) {
        if (state.getBlock() == Blocks.BEDROCK) {
            return 4;
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.TOUGHNESS_3)) {
            return 3;
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.TOUGHNESS_2)) {
            return 2;
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.TOUGHNESS_1)) {
            return 1;
        }
        return 0;
    }

    public TFCFallingBlockEntity(EntityType<? extends FallingBlockEntity> entityType, Level level) {
        super(entityType, level);
        this.dontSetBlock = false;
    }

    public TFCFallingBlockEntity(Level level, double x, double y, double z, BlockState fallingBlockState, float damagePerBlockFallen, int maximumFallDamage) {
        this(level, x, y, z, fallingBlockState);
        this.setHurtsEntities(damagePerBlockFallen, maximumFallDamage);
    }

    public TFCFallingBlockEntity(Level level, double x, double y, double z, BlockState fallingBlockState) {
        this((EntityType<? extends FallingBlockEntity>)((EntityType)TFCEntities.FALLING_BLOCK.get()), level);
        ((FallingBlockEntityAccessor)((Object)this)).setBlockState(fallingBlockState);
        this.blocksBuilding = true;
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setStartPos(this.blockPosition());
    }

    public void tick() {
        BlockState fallingBlockState = this.getBlockState();
        if (fallingBlockState.isAir()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        } else {
            Block block = fallingBlockState.getBlock();
            if (this.time++ == 0) {
                BlockPos pos = this.blockPosition();
                if (block == this.level().getBlockState(pos).getBlock()) {
                    this.level().removeBlock(pos, false);
                } else if (!this.level().isClientSide) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
                return;
            }
            this.applyGravity();
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.handlePortal();
            if (!this.level().isClientSide && (this.isAlive() || this.forceTickAfterTeleportToDuplicate)) {
                BlockPos posAt = this.blockPosition();
                if (!this.onGround()) {
                    this.failedBreakCheck = false;
                    if (this.time > 100 && (posAt.getY() < this.level().getMinBuildHeight() || posAt.getY() > this.level().getMaxBuildHeight()) || this.time > 600) {
                        this.attemptToDropAsItem(fallingBlockState);
                        this.remove(Entity.RemovalReason.DISCARDED);
                    }
                } else {
                    if (!this.failedBreakCheck) {
                        if (!FluidHelpers.isAirOrEmptyFluid(this.level().getBlockState(posAt)) && TFCFallingBlockEntity.canFallThrough((BlockGetter)this.level(), posAt, Direction.DOWN, fallingBlockState)) {
                            this.level().destroyBlock(posAt, true);
                            this.failedBreakCheck = true;
                            return;
                        }
                        if (!FluidHelpers.isAirOrEmptyFluid(this.level().getBlockState(posAt.below())) && TFCFallingBlockEntity.canFallThrough((BlockGetter)this.level(), posAt.below(), Direction.DOWN, fallingBlockState)) {
                            this.level().destroyBlock(posAt.below(), true);
                            this.failedBreakCheck = true;
                            return;
                        }
                    }
                    BlockState hitBlockState = this.level().getBlockState(posAt);
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
                    if (hitBlockState.getBlock() != Blocks.MOVING_PISTON) {
                        this.remove(Entity.RemovalReason.DISCARDED);
                        if (!this.dontSetBlock) {
                            if (this.canPlaceAt(hitBlockState, posAt, fallingBlockState, fallingBlockState)) {
                                this.placeAsBlockOrDropAsItem(hitBlockState, posAt, fallingBlockState);
                            } else {
                                BlockPos posAbove = posAt.above();
                                BlockState hitAboveBlockState = this.level().getBlockState(posAbove);
                                if (this.canPlaceAt(hitAboveBlockState, posAbove, fallingBlockState, Blocks.BEDROCK.defaultBlockState())) {
                                    this.placeAsBlockOrDropAsItem(hitAboveBlockState, posAbove, fallingBlockState);
                                } else if (TFCFallingBlockEntity.canFallThrough((BlockGetter)this.level(), posAbove, Direction.DOWN, Blocks.BEDROCK.defaultBlockState())) {
                                    this.level().destroyBlock(posAbove, true);
                                    this.placeAsBlockOrDropAsItem(hitAboveBlockState, posAbove, fallingBlockState);
                                } else {
                                    this.attemptToDropAsItem(fallingBlockState);
                                }
                            }
                        }
                        if (block instanceof IFallableBlock) {
                            IFallableBlock fallingBlock = (IFallableBlock)block;
                            fallingBlock.onceFinishedFalling(this.level(), posAt, this);
                        }
                    }
                }
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
    }

    private boolean canPlaceAt(BlockState hitBlockState, BlockPos posAt, BlockState fallingBlockState, BlockState toughnessBlockState) {
        BlockPos below = posAt.below();
        return hitBlockState.canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level(), posAt, Direction.DOWN, ItemStack.EMPTY, Direction.UP)) && fallingBlockState.canSurvive((LevelReader)this.level(), posAt) && !TFCFallingBlockEntity.canFallThrough((BlockGetter)this.level(), below, Direction.DOWN, toughnessBlockState);
    }

    private void placeAsBlockOrDropAsItem(BlockState hitBlockState, BlockPos posAt, BlockState fallingBlockState) {
        if (this.level().setBlockAndUpdate(posAt, fallingBlockState)) {
            this.afterPlacementAsBlock(hitBlockState, posAt, fallingBlockState);
        } else {
            this.attemptToDropAsItem(fallingBlockState);
        }
    }

    private void afterPlacementAsBlock(BlockState hitBlockState, BlockPos posAt, BlockState fallingBlockState) {
        BlockEntity blockEntity;
        Block block = fallingBlockState.getBlock();
        if (block instanceof FallingBlock) {
            FallingBlock fallingBlock = (FallingBlock)block;
            fallingBlock.onLand(this.level(), posAt, fallingBlockState, hitBlockState, (FallingBlockEntity)this);
        }
        if (LandslideRecipe.canLandslide(fallingBlockState)) {
            WorldTracker.get(this.level()).addLandslidePos(posAt);
        }
        if (this.blockData != null && fallingBlockState.hasBlockEntity() && (blockEntity = this.level().getBlockEntity(posAt)) != null) {
            CompoundTag blockEntityData = blockEntity.saveWithoutMetadata((HolderLookup.Provider)this.level().registryAccess());
            for (String key : blockEntityData.getAllKeys()) {
                blockEntityData.put(key, this.blockData.get(key).copy());
            }
            blockEntity.loadWithComponents(blockEntityData, (HolderLookup.Provider)this.level().registryAccess());
            blockEntity.setChanged();
        }
    }

    private void attemptToDropAsItem(BlockState fallingBlockState) {
        Level level;
        if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) && (level = this.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Helpers.dropWithContext(server, fallingBlockState, this.blockPosition(), p -> {}, true);
        }
    }
}

