/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.misc;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.items.JavelinItem;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ThrownJavelin
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> DATA_ENCHANT_GLOW = SynchedEntityData.defineId(ThrownJavelin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(ThrownJavelin.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private boolean dealtDamage = false;

    public ThrownJavelin(EntityType<? extends ThrownJavelin> type, Level level) {
        super(type, level);
    }

    public ThrownJavelin(Level level, LivingEntity entity, ItemStack stack) {
        super((EntityType)TFCEntities.THROWN_JAVELIN.get(), entity, level, stack, null);
        this.setItem(stack);
        this.setIsEnchantGlowing(stack.hasFoil());
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        super.tick();
    }

    protected void onHitEntity(EntityHitResult result) {
        if (this.getOwner() != null && this.getOwner() instanceof ServerPlayer) {
            TFCAdvancements.STAB_ENTITY.trigger((ServerPlayer)this.getOwner(), result.getEntity());
        }
        super.onHitEntity(result);
    }

    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    public void tickDespawn() {
        if (this.pickup != AbstractArrow.Pickup.ALLOWED) {
            super.tickDespawn();
        }
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pos1, Vec3 pos2) {
        return this.dealtDamage ? null : super.findHitEntity(pos1, pos2);
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)TFCSounds.JAVELIN_HIT_GROUND.get();
    }

    public float getItemAttackDamage() {
        float f;
        Item item = this.getItem().getItem();
        if (item instanceof JavelinItem) {
            JavelinItem javelin = (JavelinItem)item;
            f = javelin.getThrownDamage();
        } else {
            f = 8.0f;
        }
        return f;
    }

    public ItemStack getPickupItem() {
        return this.getItem().copy();
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)TFCItems.ROCK_TOOLS.get((Object)RockCategory.SEDIMENTARY).get((Object)RockCategory.ItemType.JAVELIN).get());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("item", 10)) {
            this.setItem(ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)tag.getCompound("item")));
            this.setIsEnchantGlowing(tag.getBoolean("glow"));
        }
        this.dealtDamage = tag.getBoolean("dealtDamage");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (!this.getItem().isEmpty()) {
            tag.put("item", this.getItem().save((HolderLookup.Provider)this.level().registryAccess(), (Tag)new CompoundTag()));
            tag.putBoolean("glow", this.isEnchantGlowing());
        }
        tag.putBoolean("dealtDamage", this.dealtDamage);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ENCHANT_GLOW, (Object)false);
        builder.define(DATA_ITEM, (Object)ItemStack.EMPTY);
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(DATA_ITEM);
    }

    public void setItem(ItemStack item) {
        this.entityData.set(DATA_ITEM, (Object)item.copy());
    }

    public boolean isEnchantGlowing() {
        return (Boolean)this.entityData.get(DATA_ENCHANT_GLOW);
    }

    public void setIsEnchantGlowing(boolean glow) {
        this.entityData.set(DATA_ENCHANT_GLOW, (Object)glow);
    }
}

