/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.predator;

import com.mojang.serialization.Dynamic;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.ai.predator.AmphibiousPredatorAi;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.entities.aquatic.TrueAmphibiousMoveControl;
import net.dries007.tfc.common.entities.predator.Predator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;

public class AmphibiousPredator
extends Predator
implements AquaticMob {
    public static AmphibiousPredator createCrocodile(EntityType<? extends Predator> type, Level level) {
        return new AmphibiousPredator(type, level, false, TFCSounds.CROCODILE);
    }

    public AmphibiousPredator(EntityType<? extends Predator> type, Level level, boolean diurnal, TFCSounds.EntityId sounds) {
        super(type, level, diurnal, sounds);
        this.setPathfindingMalus(PathType.WALKABLE, 0.0f);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new TrueAmphibiousMoveControl((Mob)this, 85, 10, 0.1f, 0.5f, false);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 20);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.9).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        return new AmphibiousPredatorNavigation(this, level);
    }

    @Override
    protected Brain.Provider<? extends Predator> brainProvider() {
        return Brain.provider(AmphibiousPredatorAi.MEMORY_TYPES, AmphibiousPredatorAi.SENSOR_TYPES);
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return AmphibiousPredatorAi.makeBrain((Brain<? extends Predator>)this.brainProvider().makeBrain(dynamic), this);
    }

    @Override
    public boolean doHurtTarget(Entity target) {
        return super.doHurtTarget(target, target.isInWaterOrBubble() ? 2 : 0);
    }

    @Override
    public boolean canSpawnIn(Fluid fluid) {
        return fluid.isSame((Fluid)Fluids.WATER);
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    @Override
    protected void customServerAiStep() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        AmphibiousPredatorAi.updateActivity(this);
    }

    public void travel(Vec3 movement) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), movement);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(movement);
        }
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public static class AmphibiousPredatorNavigation
    extends WaterBoundPathNavigation {
        AmphibiousPredatorNavigation(AmphibiousPredator animal, Level level) {
            super((Mob)animal, level);
        }

        protected PathFinder createPathFinder(int distance) {
            this.nodeEvaluator = new AmphibiousNodeEvaluator(false);
            return new PathFinder(this.nodeEvaluator, distance);
        }

        protected boolean canUpdatePath() {
            return true;
        }

        public boolean isStableDestination(BlockPos pos) {
            return !this.level.getBlockState(pos.below()).isAir();
        }
    }
}

