/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import com.mojang.serialization.Dynamic;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.PredicateMoveControl;
import net.dries007.tfc.common.entities.ai.TFCClimberNavigation;
import net.dries007.tfc.common.entities.ai.prey.PestAi;
import net.dries007.tfc.common.entities.prey.Prey;
import net.dries007.tfc.common.entities.prey.WildAnimal;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Pest
extends Prey {
    public static final EntityDataAccessor<Boolean> DATA_CLIMBING = SynchedEntityData.defineId(Pest.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState sniffingAnimation = new AnimationState();
    public final AnimationState searchingAnimation = new AnimationState();
    public final AnimationState eatingAnimation = new AnimationState();
    public final AnimationState draggingAnimation = new AnimationState();
    private static final int DRAG_TIME = 200;
    private static final int EAT_TIME = 200;
    private int dragTicks = -1;

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    public Pest(EntityType<? extends Prey> type, Level level, TFCSounds.EntityId sounds) {
        super((EntityType<? extends WildAnimal>)type, level, sounds);
        this.moveControl = new PredicateMoveControl<Pest>(this, p -> p.dragTicks == -1 || p.dragTicks > 400);
    }

    protected Brain.Provider<? extends Pest> brainProvider() {
        return Brain.provider(PestAi.MEMORY_TYPES, PestAi.SENSOR_TYPES);
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return PestAi.makeBrain((Brain<? extends Pest>)this.brainProvider().makeBrain(dynamic));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CLIMBING, (Object)false);
    }

    public void setClimbing(boolean climbing) {
        this.entityData.set(DATA_CLIMBING, (Object)climbing);
    }

    public boolean isClimbing() {
        return (Boolean)this.entityData.get(DATA_CLIMBING);
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    @Override
    public void tick() {
        ItemStack held = this.getMainHandItem();
        if (!held.isEmpty() || this.eatingAnimation.isStarted()) {
            ++this.dragTicks;
            if (this.dragTicks < 200) {
                if (this.level().isClientSide) {
                    this.draggingAnimation.startIfStopped(this.tickCount);
                }
            } else {
                if (this.level().isClientSide) {
                    this.draggingAnimation.stop();
                    this.eatingAnimation.startIfStopped(this.tickCount);
                    if (!held.isEmpty()) {
                        this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, held), this.getX(), this.getEyeY(), this.getZ(), (double)Helpers.triangle(this.random), (double)(-this.random.nextFloat()), (double)Helpers.triangle(this.random));
                    }
                    if (this.random.nextInt(20) == 0) {
                        this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
                    }
                }
                if (this.dragTicks > 400) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    if (this.level().isClientSide) {
                        this.eatingAnimation.stop();
                    }
                    this.playSound(SoundEvents.PLAYER_BURP, this.getSoundVolume(), this.getVoicePitch());
                }
            }
        } else {
            this.dragTicks = -1;
        }
        if (this.level().isClientSide && this.dragTicks == -1 && !EntityHelpers.isMovingOnLand((Entity)this) && this.random.nextInt(20) == 0) {
            if (this.random.nextBoolean()) {
                this.sniffingAnimation.startIfStopped(this.tickCount);
                this.playSound(SoundEvents.FOX_SNIFF, this.getSoundVolume(), this.getVoicePitch());
            } else {
                this.searchingAnimation.startIfStopped(this.tickCount);
                this.playSound(SoundEvents.FOX_SNIFF, this.getSoundVolume(), this.getVoicePitch());
            }
        }
        super.tick();
        if (!this.level().isClientSide) {
            this.setClimbing(this.horizontalCollision);
            if (this.tickCount > 3600 && this.random.nextInt(500) == 0 && !this.isPersistenceRequired()) {
                this.discard();
            }
        }
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        return new TFCClimberNavigation((Mob)this, level);
    }

    @Override
    public boolean removeWhenFarAway(double distance) {
        return !this.isPersistenceRequired();
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficulty, spawnType, spawnData);
        if (this.random.nextInt(1000) == 0) {
            this.setCustomName((Component)Component.literal((String)"Pak"));
        }
        if (this.random.nextFloat() < 0.2f) {
            this.setBaby(true);
        }
        return spawnData;
    }
}

