/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.prey.RammingPreyAi;
import net.dries007.tfc.common.entities.prey.WildAnimal;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class RammingPrey
extends WildAnimal {
    protected static final ImmutableList<SensorType<? extends Sensor<? super RammingPrey>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ITEMS, (Object)SensorType.NEAREST_ADULT, (Object)SensorType.HURT_BY);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object)MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)MemoryModuleType.RAM_TARGET, (Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.HURT_BY_ENTITY);
    private final Supplier<SoundEvent> attack;
    public final AnimationState telegraphAnimation = new AnimationState();
    public final AnimationState attackingAnimation = new AnimationState();
    private boolean isTelegraphingAttack;
    private int telegraphAttackTick;
    private float attackDamageMultiplier = 1.0f;
    private final double rammingReach;
    public final AnimationState walkingAnimation = new AnimationState();

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.16f).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.8).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public static AttributeSupplier.Builder createMediumAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, (double)0.16f).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.9).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public static AttributeSupplier.Builder createLargeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, (double)0.12f).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public RammingPrey(EntityType<? extends RammingPrey> type, Level level, TFCSounds.EntityId sounds, double rammingReach) {
        super(type, level, sounds);
        this.attack = sounds.attack().orElseThrow();
        this.rammingReach = rammingReach;
    }

    protected Brain.Provider<? extends RammingPrey> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return RammingPreyAi.makeBrain((Brain<? extends RammingPrey>)this.brainProvider().makeBrain(dynamic));
    }

    protected void customServerAiStep() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        RammingPreyAi.updateActivity(this);
    }

    public Brain<RammingPrey> getBrain() {
        return super.getBrain();
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean hurt = super.hurt(source, amount);
        if (!this.level().isClientSide && this.isAlive()) {
            this.brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        }
        return hurt;
    }

    @Override
    public void tick() {
        if (this.level().isClientSide) {
            EntityHelpers.startOrStop(this.walkingAnimation, EntityHelpers.isMovingOnLand((Entity)this), this.tickCount);
        }
        super.tick();
    }

    public void handleEntityEvent(byte id) {
        if (id == 58) {
            this.isTelegraphingAttack = true;
        } else if (id == 59) {
            this.isTelegraphingAttack = false;
        } else if (id == 4) {
            this.attackingAnimation.start(this.tickCount);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void aiStep() {
        this.telegraphAttackTick = this.isTelegraphingAttack ? ++this.telegraphAttackTick : 0;
        this.telegraphAttackTick = Mth.clamp((int)this.telegraphAttackTick, (int)0, (int)20);
        super.aiStep();
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        RammingPreyAi.initMemories(this, level.getRandom());
        return super.finalizeSpawn(level, difficulty, spawnType, spawnData);
    }

    public int getTelegraphAttackTick() {
        return this.telegraphAttackTick;
    }

    public boolean isTelegraphingAttack() {
        return this.isTelegraphingAttack;
    }

    public Supplier<SoundEvent> getAttackSound() {
        return this.attack;
    }

    public void setAttackDamageMultiplier(float multiplier) {
        this.attackDamageMultiplier = multiplier;
    }

    public float getAttackDamageMultiplier() {
        return this.attackDamageMultiplier;
    }

    public double getRammingReach() {
        return this.rammingReach;
    }
}

